/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import commands.CommandManager;
import commands.changetext.ChangeTextStyleBoldCommand;
import commands.changetext.ChangeTextStyleFontNameCommand;
import commands.changetext.ChangeTextStyleFontSizeCommand;
import commands.changetext.ChangeTextStyleItalicCommand;
import commands.changetext.ChangeTextStyleUnderlinedCommand;
import commands.changetext.CopyToClipboard;
import commands.changetext.DeleteCommand;
import commands.changetext.InsertCharactersCommand;
import commands.changetext.InsertFromClipboardCommand;
import commands.changetext.SetAlignmentCommand;
import document.text.AttributedText;
import document.text.AttributedTextLayouter;
import document.text.ChunkPosition;
import document.text.CursorShape;
import document.text.HorizontalAlignment;
import document.text.Line;
import document.text.Suggestions;
import document.text.TextFieldView;
import document.text.TextStyle;
import document.text.TextStyleFactory;
import document.text.VerticalAlignment;
import document.text.chunks.SpellingState;
import document.text.chunks.TextChunk;
import document.text.menutext.TextMenu;
import document.text.spellcheck.Spellchecker;
import gui.actions.editgroupzorder.CopyAction;
import gui.actions.editgroupzorder.CutAction;
import gui.actions.textstyle.SetBoldAction;
import gui.actions.textstyle.SetItalicsAction;
import gui.actions.textstyle.SetUnderlinedAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.components.toolbars.fontchooser.FontNameChooserComboBox;
import gui.components.toolbars.fontchooser.FontSizeChooserComboBox;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import util.math.PointDouble;
import util.math.PointFloat;

public class TextFieldController
implements TextFieldView {
    VerticalAlignment verticalAlignment = VerticalAlignment.top;
    float yOffset = 0.0f;
    float lastBottomOfText;
    float lastTopOfText;
    long lastRenderedTimeStamp = -1L;
    int rendercounter = 0;
    AttributedTextLayouter textLayouter;
    int cursorPos = 0;
    CommandManager commandManager = new CommandManager();
    private TextStyle activeTextStyle;
    private InsertMode insertMode = InsertMode.insert;
    private boolean mouseLeftIsDown = false;
    private boolean markingActive = false;
    int markStart;
    int markEnd;
    int lastRenderedMarkStart = -1;
    int lastRenderedMarkEnd = -1;
    TextFieldView textFieldView;
    float left;
    float top;
    private float borderLeft = 0.1f;
    private float borderRight = 0.1f;
    private float borderTop = 0.1f;
    private float borderBottom = 0.0f;
    private boolean focus = false;

    public TextFieldController(TextFieldView textFieldView) {
        AttributedText attributedText = new AttributedText();
        this.textLayouter = new AttributedTextLayouter(attributedText);
        this.textFieldView = textFieldView;
        this.activeTextStyle = attributedText.getTextStyle(attributedText.intToChunkPosition(0));
    }

    public void setBorders(float borderLeft, float borderRight, float borderTop, float borderBottom) {
        this.borderLeft = borderLeft;
        this.borderRight = borderRight;
        this.borderTop = borderTop;
        this.borderBottom = borderBottom;
    }

    public void setTopLeft(float top, float left) {
        this.top = top;
        this.left = left;
    }

    public AttributedText getText() {
        return this.textLayouter.getAttributedText();
    }

    public void render(Rectangle2D boundsRect, boolean renderOnlyDirtyRegions, boolean printing) {
        this.reformatWholeLayout();
        if (this.verticalAlignment != VerticalAlignment.top) {
            renderOnlyDirtyRegions = false;
        }
        this.yOffset = this.textLayouter.calculateYOffset(this.verticalAlignment, this.borderTop, this.borderBottom);
        if (renderOnlyDirtyRegions && this.lastRenderedMarkStart != -1 && this.focus && !printing) {
            this.renderMarkings(true);
        }
        if (boundsRect != null) {
            boundsRect.setRect(boundsRect.getX() - (double)this.left - (double)this.borderLeft, boundsRect.getY() - (double)this.top - (double)this.borderTop - (double)this.yOffset, boundsRect.getWidth(), boundsRect.getHeight());
        }
        float bottomOfText = this.textLayouter.getRealUsedTextHeight() + this.top + this.borderTop + this.yOffset;
        float topOfText = this.textLayouter.getLines().get(0).getTop() + this.yOffset;
        if (renderOnlyDirtyRegions) {
            this.lastRenderedTimeStamp = this.textLayouter.render(this, boundsRect, this.lastRenderedTimeStamp, this.focus, printing);
            if (bottomOfText < this.lastBottomOfText) {
                if (this.lastBottomOfText <= this.top + this.borderTop + this.textLayouter.getHeight()) {
                    this.textFieldView.eraseBackground(bottomOfText, this.lastBottomOfText);
                } else {
                    this.textFieldView.restoreBackground(bottomOfText, this.lastBottomOfText);
                }
            }
            if (topOfText < this.lastTopOfText) {
                this.textFieldView.eraseBackground(topOfText, this.lastTopOfText);
            }
        } else {
            this.lastRenderedTimeStamp = this.textLayouter.render(this, boundsRect, -1L, this.focus && !printing, printing);
        }
        this.lastBottomOfText = bottomOfText;
        this.lastTopOfText = topOfText;
        if (this.isMarkingActive() && this.focus && !printing) {
            this.renderMarkings(false);
            this.lastRenderedMarkEnd = this.markEnd;
            this.lastRenderedMarkStart = this.markStart;
        } else {
            this.lastRenderedMarkStart = -1;
        }
    }

    public void renderMarkings(boolean renderOldMarkings) {
        ChunkPosition mark2;
        ChunkPosition mark1;
        if (!renderOldMarkings) {
            if (this.markStart < this.markEnd) {
                mark1 = this.getText().intToChunkPosition(this.markStart);
                mark2 = this.getText().intToChunkPosition(this.markEnd);
            } else {
                mark2 = this.getText().intToChunkPosition(this.markStart);
                mark1 = this.getText().intToChunkPosition(this.markEnd);
            }
        } else if (this.lastRenderedMarkStart < this.lastRenderedMarkEnd) {
            mark1 = this.getText().intToChunkPosition(this.lastRenderedMarkStart);
            mark2 = this.getText().intToChunkPosition(this.lastRenderedMarkEnd);
        } else {
            mark2 = this.getText().intToChunkPosition(this.lastRenderedMarkStart);
            mark1 = this.getText().intToChunkPosition(this.lastRenderedMarkEnd);
        }
        Line startLine = this.textLayouter.getLine(mark1);
        Line endLine = this.textLayouter.getLine(mark2);
        PointFloat pointStart = startLine.getPosition(mark1);
        PointFloat pointEnd = endLine.getPosition(mark2);
        float y1 = pointStart.y - startLine.getAscent();
        float y2 = pointStart.y + startLine.getDescent();
        float x1 = pointStart.x;
        float x2 = startLine == endLine ? pointEnd.x : this.textLayouter.getWidth();
        this.invertRectangle(new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1));
        if (startLine != endLine && startLine.getNextLine() != endLine) {
            y1 = pointStart.y + startLine.getDescent();
            y2 = pointEnd.y - endLine.getAscent();
            x1 = 0.0f;
            x2 = this.textLayouter.getWidth();
            this.invertRectangle(new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1));
        }
        if (startLine != endLine) {
            x1 = 0.0f;
            x2 = pointEnd.x;
            y1 = pointEnd.y - endLine.getAscent();
            y2 = pointEnd.y + endLine.getDescent();
            this.invertRectangle(new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1));
        }
    }

    public void mouseMoved(float x, float y, MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) != 0 && this.mouseLeftIsDown) {
            ChunkPosition cp = this.textLayouter.getHitPosition(x -= this.borderLeft + this.left, y -= this.borderTop + this.top + this.yOffset);
            this.setMarkingActive(true);
            this.cursorPos = this.markEnd = this.getText().chunkPositionToint(cp.getCopy());
            this.identifyActiveTextStyle();
        }
    }

    public void mouseLeftDown(float x, float y, boolean shiftPressed) {
        ChunkPosition cp = this.textLayouter.getHitPosition(x -= this.borderLeft + this.left, y -= this.borderTop + this.top + this.yOffset);
        if (shiftPressed) {
            if (!this.isMarkingActive()) {
                this.markStart = this.cursorPos;
                this.setMarkingActive(true);
            }
            this.cursorPos = this.markEnd = this.getText().chunkPositionToint(cp);
        } else {
            this.cursorPos = this.textLayouter.getAttributedText().chunkPositionToint(cp);
            this.markEnd = this.markStart = this.getText().chunkPositionToint(cp);
            this.setMarkingActive(false);
        }
        this.mouseLeftIsDown = true;
        this.identifyActiveTextStyle();
    }

    public void mouseRightDown(float x, float y) {
    }

    public void mouseLeftUp(float x, float y) {
        this.mouseLeftIsDown = false;
    }

    public void mouseRightUp(float x, float y) {
    }

    public void ESCpressed() {
    }

    public int getPosOneLineDown(int pos) {
        int position;
        Line nextLine;
        ChunkPosition cp = this.getText().intToChunkPosition(pos);
        Line line = this.textLayouter.getLine(cp);
        if (line != (nextLine = line.getNextLine()) && nextLine != null) {
            PointFloat p = line.getPosition(cp);
            p.y += line.getDescent() + nextLine.getAscent();
            cp = nextLine.getHitPosition(p.x, p.y);
            position = this.getText().chunkPositionToint(cp);
        } else {
            position = pos;
        }
        return position;
    }

    public int getPosOneLineUp(int pos) {
        int position;
        Line previousLine;
        ChunkPosition cp = this.getText().intToChunkPosition(pos);
        Line line = this.textLayouter.getLine(cp);
        if (line != (previousLine = line.getPreviousLine()) && previousLine != null) {
            PointFloat p = line.getPosition(cp);
            p.y += previousLine.getDescent() + line.getAscent();
            cp = previousLine.getHitPosition(p.x, p.y);
            position = this.getText().chunkPositionToint(cp);
        } else {
            position = pos;
        }
        return position;
    }

    private boolean keyboardCursorMove(int newPos, int modifiers) {
        boolean drawTextfieldNecessary = false;
        if (newPos != this.cursorPos) {
            if ((modifiers & 0x40) != 0) {
                if (!this.isMarkingActive()) {
                    this.setMarkingActive(true);
                    this.markStart = this.cursorPos;
                }
                this.markEnd = this.cursorPos = newPos;
                drawTextfieldNecessary = true;
            } else {
                this.cursorPos = newPos;
                if (this.isMarkingActive()) {
                    this.setMarkingActive(false);
                    drawTextfieldNecessary = true;
                    this.markStart = 0;
                    this.markEnd = 0;
                }
            }
        }
        return drawTextfieldNecessary;
    }

    public boolean keyboardpressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        boolean consumeEvent = true;
        switch (keyCode) {
            case 37: {
                if (this.cursorPos > 0 && !this.keyboardCursorMove(this.cursorPos - 1, modifiers)) {
                    e.consume();
                    consumeEvent = false;
                }
                this.identifyActiveTextStyle();
                break;
            }
            case 39: {
                if (this.cursorPos < this.getText().getTextLength() && !this.keyboardCursorMove(this.cursorPos + 1, modifiers)) {
                    e.consume();
                    consumeEvent = false;
                }
                this.identifyActiveTextStyle();
                break;
            }
            case 38: {
                if (!this.keyboardCursorMove(this.getPosOneLineUp(this.cursorPos), modifiers)) {
                    e.consume();
                    consumeEvent = false;
                }
                this.identifyActiveTextStyle();
                break;
            }
            case 40: {
                if (!this.keyboardCursorMove(this.getPosOneLineDown(this.cursorPos), modifiers)) {
                    e.consume();
                    consumeEvent = false;
                }
                this.identifyActiveTextStyle();
                break;
            }
            case 8: {
                int textLength = this.getText().getTextLength();
                if (this.cursorPos <= 0) break;
                int textToClearBegin = this.cursorPos - 1;
                int textToClearEnd = this.cursorPos;
                if (this.isMarkingActive()) {
                    textToClearBegin = this.markStart;
                    textToClearEnd = this.markEnd;
                }
                if (textToClearBegin > textLength) {
                    textToClearBegin = textLength;
                }
                if (textToClearEnd > textLength) {
                    textToClearEnd = textLength;
                }
                DeleteCommand dcommand = new DeleteCommand(DeleteCommand.DeleteCommandType.backspace, this.cursorPos, this.cursorPos - 1, textToClearBegin, textToClearEnd, this.isMarkingActive(), this, this.commandManager);
                this.textLayouter.reformatWholeLayout();
                this.identifyActiveTextStyle();
                break;
            }
            case 127: {
                if ((modifiers & 0x40) != 0) {
                    this.copyToClipboard(true);
                    break;
                }
                int textLength = this.getText().getTextLength();
                if (this.cursorPos >= textLength && !this.isMarkingActive()) break;
                int textToClearBegin = this.cursorPos;
                int textToClearEnd = this.cursorPos + 1;
                if (this.isMarkingActive()) {
                    textToClearBegin = this.markStart;
                    textToClearEnd = this.markEnd;
                }
                if (textToClearBegin > textLength) {
                    textToClearBegin = textLength;
                }
                if (textToClearEnd > textLength) {
                    textToClearEnd = textLength;
                }
                if (textToClearEnd == textToClearBegin) break;
                DeleteCommand dcommand = new DeleteCommand(DeleteCommand.DeleteCommandType.delete, this.cursorPos, this.cursorPos, textToClearBegin, textToClearEnd, this.isMarkingActive(), this, this.commandManager);
                this.textLayouter.reformatWholeLayout();
                this.identifyActiveTextStyle();
                break;
            }
            case 10: {
                break;
            }
            case 34: {
                break;
            }
            case 33: {
                break;
            }
            case 36: {
                this.cursorPos = 0;
                this.identifyActiveTextStyle();
                break;
            }
            case 35: {
                this.cursorPos = this.getText().getTextLength();
                this.identifyActiveTextStyle();
                break;
            }
            case 155: {
                if ((modifiers & 0x40) != 0) {
                    this.pasteTextFromClipboard(false);
                    break;
                }
                if ((modifiers & 0x80) != 0) {
                    this.copyToClipboard(false);
                    break;
                }
                consumeEvent = false;
                break;
            }
            case 66: {
                if ((modifiers & 0x80) != 0) {
                    this.pasteTextFromClipboard(true);
                    break;
                }
                consumeEvent = false;
                break;
            }
            case 86: {
                if ((modifiers & 0x80) != 0) {
                    this.pasteTextFromClipboard(false);
                    break;
                }
                consumeEvent = false;
                break;
            }
            case 67: {
                if ((modifiers & 0x80) != 0) {
                    this.copyToClipboard(false);
                    break;
                }
                consumeEvent = false;
                break;
            }
            case 88: {
                if ((modifiers & 0x80) != 0) {
                    this.copyToClipboard(true);
                    break;
                }
                consumeEvent = false;
                break;
            }
            case 45: {
                if ((modifiers & 0x80) != 0) {
                    this.getText().insertManualHyphenation(this.cursorPos);
                    this.textLayouter.forceReformatWholeLayout();
                    this.lastRenderedTimeStamp = -1L;
                    break;
                }
                consumeEvent = false;
                break;
            }
            default: {
                consumeEvent = false;
            }
        }
        if (consumeEvent) {
            e.consume();
        }
        return consumeEvent;
    }

    public void copyToClipboard(boolean deleteCopiedText) {
        CopyToClipboard cmd = new CopyToClipboard(this.cursorPos, this.markStart, this.markEnd, deleteCopiedText, this, this.commandManager);
        this.reformatWholeLayout();
        this.identifyActiveTextStyle();
    }

    public void pasteTextFromClipboard(boolean parseMenus) {
        InsertFromClipboardCommand cmd = new InsertFromClipboardCommand(this.cursorPos, null, this.cursorPos, this.markStart, this.markEnd, parseMenus, this, this.commandManager);
        this.reformatWholeLayout();
        this.identifyActiveTextStyle();
    }

    public boolean keyTyped(KeyEvent e) {
        boolean goodKey = true;
        char c = e.getKeyChar();
        if (!this.isMarkingActive()) {
            this.markStart = 0;
            this.markEnd = 0;
        }
        char code = c;
        if ((e.getModifiersEx() & 0x80) == 0) {
            switch (code) {
                case '\b': 
                case '\u007f': {
                    goodKey = false;
                    break;
                }
                default: {
                    InsertCharactersCommand icommand = new InsertCharactersCommand(this.cursorPos, this.cursorPos, this.cursorPos + 1, this.markStart, this.markEnd, "" + c, this.activeTextStyle, this, this.commandManager, null);
                    this.textLayouter.reformatWholeLayout();
                    this.identifyActiveTextStyle();
                    e.consume();
                }
            }
        }
        return goodKey;
    }

    @Override
    public void setTextStyle(TextStyle textStyle) {
        this.textFieldView.setTextStyle(textStyle);
    }

    @Override
    public void renderText(float x, float y, TextChunk textChunk, int start, int end) {
        this.textFieldView.renderText(x + this.left + this.borderLeft, y + this.top + this.borderTop + this.yOffset, textChunk, start, end);
    }

    @Override
    public void invertRectangle(Rectangle2D.Float rect) {
        float a = 0.0f;
        rect.x += this.left + this.borderLeft - a;
        rect.y += this.top + this.borderTop - a + this.yOffset;
        rect.width += a;
        rect.height += a;
        this.textFieldView.invertRectangle(rect);
    }

    public AttributedText getAttributedText() {
        return this.textLayouter.getAttributedText();
    }

    public void setAttributedText(AttributedText attributedText) {
        this.textLayouter.setAttributedText(attributedText);
    }

    public void setWidthHeight(float width, float height) {
        this.textLayouter.setWidthHeight(width - this.borderLeft - this.borderRight, height - this.borderTop - this.borderBottom);
        this.lastBottomOfText = height - this.borderBottom;
    }

    public void copyTo(TextFieldController tfc) {
        tfc.borderBottom = this.borderBottom;
        tfc.borderLeft = this.borderLeft;
        tfc.borderTop = this.borderTop;
        tfc.borderRight = this.borderRight;
        tfc.setTopLeft(this.top, this.left);
        tfc.setAttributedText(this.getAttributedText().getCopy());
        tfc.setWidthHeight(this.getWidth(), this.getHeight());
    }

    public float getWidth() {
        return this.textLayouter.getWidth() + this.borderLeft + this.borderRight;
    }

    public float getHeight() {
        return this.textLayouter.getHeight() + this.borderTop + this.borderBottom;
    }

    public float getBottomOfTextArea() {
        return this.borderTop + this.textLayouter.getHeight();
    }

    @Override
    public PointFloat mouseCoordinatesToObjectCoordinates(PointFloat mousePos) {
        mousePos = this.textFieldView.mouseCoordinatesToObjectCoordinates(mousePos);
        mousePos.x -= this.left + this.borderLeft;
        mousePos.y -= this.top + this.borderTop + this.yOffset;
        return mousePos;
    }

    public boolean isInside(PointDouble mousePos) {
        return mousePos.x - (double)this.left >= (double)this.borderLeft && mousePos.x - (double)this.left <= (double)(this.getWidth() - this.borderRight) && mousePos.y - (double)this.top >= (double)this.borderTop && mousePos.y - (double)this.top <= (double)(this.getHeight() - this.borderBottom) || this.focus && this.getAdditionalTextRectangle().contains(mousePos);
    }

    public CursorShape getCursorShape() {
        ChunkPosition cp = this.textLayouter.getAttributedText().intToChunkPosition(this.cursorPos);
        PointFloat p = this.textLayouter.getPosition(cp);
        CursorShape cs = this.activeTextStyle.getCursorShape(p);
        cs.translate(this.left + this.borderLeft, this.top + this.borderTop + this.yOffset);
        return cs;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public float getTop() {
        return this.top;
    }

    public void setTop(float top) {
        this.top = top;
    }

    public InsertMode getInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(InsertMode insertMode) {
        this.insertMode = insertMode;
    }

    public void setCursor(int cursorAfter) {
        this.cursorPos = cursorAfter;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void reformatWholeLayout() {
        this.textLayouter.reformatWholeLayout();
    }

    public void invalidateAndReformatWholeLayout() {
        this.textLayouter.forceReformatWholeLayout();
    }

    public boolean isMarkingActive() {
        return this.markingActive;
    }

    public void setMarkingActive(boolean markingActive) {
        this.markingActive = markingActive;
        CopyAction.getInstance().setEnabled(markingActive);
        CutAction.getInstance().setEnabled(markingActive);
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        if (markingActive) {
            controller.getCursorController().setEnabled(false);
        } else {
            controller.getCursorController().setEnabled(true);
        }
    }

    public void clearMarkingActiveState() {
        this.markingActive = false;
    }

    public int getMarkStart() {
        return this.markStart;
    }

    public void setMarkStart(int markStart) {
        this.markStart = markStart;
    }

    public int getMarkEnd() {
        return this.markEnd;
    }

    public void setMarkEnd(int markEnd) {
        this.markEnd = markEnd;
    }

    public void setItalics(boolean isItalic) {
        if (this.isMarkingActive()) {
            ChangeTextStyleItalicCommand command = new ChangeTextStyleItalicCommand(this.markStart, this.markEnd, isItalic, this, this.commandManager);
            this.textLayouter.reformatWholeLayout();
        }
        this.activeTextStyle = TextStyleFactory.getInstance().getTextStyle(this.activeTextStyle.getFontName(), this.activeTextStyle.getSize(), this.activeTextStyle.getFontColor(), this.activeTextStyle.isUnderlined(), this.activeTextStyle.isBold(), isItalic);
    }

    public void identifyActiveTextStyle() {
        TextStyle ts = this.isMarkingActive() ? this.getText().getTextStyle(this.getText().intToChunkPosition(this.markEnd)) : this.getText().getTextStyle(this.getText().intToChunkPosition(this.cursorPos));
        this.activeTextStyle = ts;
        this.setTextStyleBarStatus();
    }

    public TextStyle getActiveTextStyle() {
        return this.activeTextStyle;
    }

    public void setTextStyleBarStatus() {
        SetItalicsAction.getInstance().getButton().setSelected(this.activeTextStyle.isItalic());
        SetBoldAction.getInstance().getButton().setSelected(this.activeTextStyle.isBold());
        SetUnderlinedAction.getInstance().getButton().setSelected(this.activeTextStyle.isUnderlined());
        FontNameChooserComboBox.getInstance().setFontName(this.activeTextStyle.getFontName());
        FontSizeChooserComboBox.getInstance().setFontSize(this.activeTextStyle.getSize());
    }

    public void setBold(boolean isBold) {
        if (this.isMarkingActive()) {
            ChangeTextStyleBoldCommand command = new ChangeTextStyleBoldCommand(this.markStart, this.markEnd, isBold, this, this.commandManager);
            this.textLayouter.reformatWholeLayout();
        }
        this.activeTextStyle = TextStyleFactory.getInstance().getTextStyle(this.activeTextStyle.getFontName(), this.activeTextStyle.getSize(), this.activeTextStyle.getFontColor(), this.activeTextStyle.isUnderlined(), isBold, this.activeTextStyle.isItalic());
    }

    public void setFontName(String fontName) {
        if (this.isMarkingActive()) {
            ChangeTextStyleFontNameCommand command = new ChangeTextStyleFontNameCommand(this.markStart, this.markEnd, fontName, this, this.commandManager);
            this.textLayouter.reformatWholeLayout();
        }
        this.activeTextStyle = TextStyleFactory.getInstance().getTextStyle(fontName, this.activeTextStyle.getSize(), this.activeTextStyle.getFontColor(), this.activeTextStyle.isUnderlined(), this.activeTextStyle.isBold(), this.activeTextStyle.isItalic());
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        if (this.isMarkingActive()) {
            SetAlignmentCommand command = new SetAlignmentCommand(this.markStart, this.markEnd, alignment, this, this.commandManager);
        } else {
            SetAlignmentCommand setAlignmentCommand = new SetAlignmentCommand(this.cursorPos, -1, alignment, this, this.commandManager);
        }
        this.reformatWholeLayout();
    }

    public void setFontSize(int size) {
        if (this.isMarkingActive()) {
            ChangeTextStyleFontSizeCommand command = new ChangeTextStyleFontSizeCommand(this.markStart, this.markEnd, size, this, this.commandManager);
            this.textLayouter.reformatWholeLayout();
        }
        this.activeTextStyle = TextStyleFactory.getInstance().getTextStyle(this.activeTextStyle.getFontName(), size, this.activeTextStyle.getFontColor(), this.activeTextStyle.isUnderlined(), this.activeTextStyle.isBold(), this.activeTextStyle.isItalic());
    }

    public Rectangle2D getTextRectangle() {
        return new Rectangle2D.Double(this.left + this.borderLeft, this.top + this.borderTop + this.yOffset, this.textLayouter.getWidth(), this.textLayouter.getHeight());
    }

    public Rectangle2D getAdditionalTextRectangle() {
        double height = this.textLayouter.getRealUsedTextHeight() - this.textLayouter.getHeight();
        if (height < 0.0) {
            height = 0.0;
        }
        return new Rectangle2D.Double(this.left + this.borderLeft, this.top + this.borderTop + this.textLayouter.getHeight(), this.textLayouter.getWidth(), height);
    }

    public boolean hasFocus() {
        return this.focus;
    }

    public void setFocus(boolean hasFocus) {
        this.focus = hasFocus;
        if (hasFocus) {
            int textLength = this.getAttributedText().getTextLength();
            if (this.cursorPos > textLength) {
                this.cursorPos = textLength;
            }
            if (this.markingActive) {
                if (this.markEnd > textLength) {
                    this.markEnd = textLength;
                }
                if (this.markStart > textLength) {
                    this.markStart = textLength;
                }
            }
        }
    }

    @Override
    public void eraseBackground(float fromY, float toY) {
        this.textFieldView.eraseBackground(fromY + this.top + this.borderTop + this.yOffset, toY + this.top + this.borderTop + this.yOffset);
    }

    public float getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(float borderLeft) {
        this.borderLeft = borderLeft;
    }

    public float getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(float borderRight) {
        this.borderRight = borderRight;
    }

    public float getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(float borderTop) {
        this.borderTop = borderTop;
    }

    public float getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(float borderBottom) {
        this.borderBottom = borderBottom;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public boolean hasAdditionalText() {
        return (double)(this.textLayouter.getRealUsedTextHeight() - this.textLayouter.getHeight()) > 1.0E-6;
    }

    @Override
    public void restoreBackground(float fromY, float toY) {
        this.textFieldView.eraseBackground(fromY + this.top + this.borderTop + this.yOffset, toY + this.top + this.borderTop + this.yOffset);
    }

    @Override
    public void underline(float fromX, float toX, float y, float width) {
        this.textFieldView.underline(fromX + this.left + this.borderLeft, toX + this.left + this.borderLeft, y + this.top + this.borderTop + this.yOffset, width);
    }

    public void setUnderlined(boolean underlined) {
        if (this.isMarkingActive()) {
            ChangeTextStyleUnderlinedCommand command = new ChangeTextStyleUnderlinedCommand(this.markStart, this.markEnd, underlined, this, this.commandManager);
            this.textLayouter.reformatWholeLayout();
        }
        this.activeTextStyle = TextStyleFactory.getInstance().getTextStyle(this.activeTextStyle.getFontName(), this.activeTextStyle.getSize(), this.activeTextStyle.getFontColor(), underlined, this.activeTextStyle.isBold(), this.activeTextStyle.isItalic());
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public TextMenu getTextMenu(float x, float y) {
        ChunkPosition cp = this.textLayouter.getHitPosition(x -= this.borderLeft + this.left, y -= this.borderTop + this.top + this.yOffset);
        if (cp.getChunk() instanceof TextChunk) {
            return ((TextChunk)cp.getChunk()).getTextMenu();
        }
        return null;
    }

    public Suggestions getSuggestions(float x, float y) {
        TextChunk tc;
        String text;
        Suggestions ret = null;
        ChunkPosition cp = this.textLayouter.getHitPosition(x -= this.borderLeft + this.left, y -= this.borderTop + this.top + this.yOffset);
        if (cp.getChunk() instanceof TextChunk && (text = (tc = (TextChunk)cp.getChunk()).getText()).length() > 1) {
            char lastChar = text.charAt(text.length() - 1);
            if (lastChar == '.' || lastChar == ';' || lastChar == ':') {
                text = text.substring(0, text.length() - 1);
            }
            if (tc.getSpellingState() == SpellingState.incorrect) {
                int from = this.getAttributedText().chunkPositionToint(new ChunkPosition(tc, 0));
                int to = this.getAttributedText().chunkPositionToint(new ChunkPosition(tc, text.length()));
                ret = new Suggestions(Spellchecker.getInstance().getDictionary().suggest(text), from, to);
            }
        }
        return ret;
    }

    public boolean isPersonalInsertSuggestion(String name) {
        String text = this.getAttributedText().getText();
        int posEnd = this.getCursorPos();
        while (posEnd > 0 && text.charAt(posEnd) != '.') {
            --posEnd;
        }
        int posStart = posEnd == 0 ? 0 : posEnd - 1;
        while (posStart > 0 && text.charAt(posStart) != '.') {
            --posStart;
        }
        String lastSentence = text.substring(posStart, posEnd);
        return !(lastSentence = lastSentence.toLowerCase()).contains(name = name.toLowerCase());
    }

    public void insertBemerkung(String bemerkungWithMenu) {
        String text = this.getAttributedText().getText();
        if (this.cursorPos > 0 && text.length() > this.cursorPos - 1 && text.charAt(this.cursorPos - 1) != ' ') {
            bemerkungWithMenu = " " + bemerkungWithMenu;
        }
        if (this.cursorPos < text.length() && text.charAt(this.cursorPos) != ' ') {
            bemerkungWithMenu = String.valueOf(bemerkungWithMenu) + " ";
        }
        InsertFromClipboardCommand cmd = new InsertFromClipboardCommand(this.cursorPos, bemerkungWithMenu, this.cursorPos, this.markStart, this.markEnd, true, this, this.commandManager);
        this.reformatWholeLayout();
        this.identifyActiveTextStyle();
    }

    public static enum InsertMode {
        insert,
        overwrite;

    }
}

