/*
 * Decompiled with CFR 0.152.
 */
package document.text.hyphenation;

import document.text.hyphenation.Hyphenator;
import java.io.IOException;
import util.io.IO;
import util.logging.Log;

public class TableBasedHyphenator
implements Hyphenator {
    private net.davidashen.text.Hyphenator hyphenator;
    private boolean tableOpenedSuccessfully = false;
    private final char HYPHEN = (char)173;

    public TableBasedHyphenator() {
        this.hyphenator = new net.davidashen.text.Hyphenator();
        try {
            this.hyphenator.loadTable(IO.openDataFile("data/hyphenation/dehypha.tex"));
            this.tableOpenedSuccessfully = true;
        }
        catch (IOException ex) {
            Log.log(3, "Konnte Trenndatei nicht \u00f6ffnen.");
        }
    }

    @Override
    public byte[] getHyphenationArray(String s) {
        if (this.tableOpenedSuccessfully) {
            String hyphenated = this.hyphenator.hyphenate(s);
            int count = 0;
            int pos = 1;
            int i = 1;
            while (i < hyphenated.length() - 2) {
                if (hyphenated.charAt(i) == '\u00ad') {
                    if (pos < s.length() && s.charAt(pos) != '-') {
                        ++count;
                    } else {
                        pos = (byte)(pos + 1);
                    }
                } else {
                    pos = (byte)(pos + 1);
                }
                i = (byte)(i + 1);
            }
            byte[] ret = new byte[count];
            count = 0;
            pos = 1;
            int i2 = 1;
            while (i2 < hyphenated.length() - 2) {
                if (hyphenated.charAt(i2) == '\u00ad') {
                    if (pos < s.length() && s.charAt(pos) != '-') {
                        ret[count] = pos;
                        ++count;
                    } else {
                        pos = (byte)(pos + 1);
                    }
                } else {
                    pos = (byte)(pos + 1);
                }
                i2 = (byte)(i2 + 1);
            }
            return ret;
        }
        return new byte[0];
    }

    @Override
    public String getComplicatedWordsFilename() {
        return "data/hyphenation/complicated_words_table.txt";
    }
}

