/*
 * Decompiled with CFR 0.152.
 */
package document.view;

import commands.CommandManager;
import document.MyDocument;
import document.MyObject;
import document.MyPage;
import document.Renderable;
import document.Serializable;
import document.view.ArtificialLines;
import document.view.Borders;
import document.view.Grid;
import init.Settings;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.math.RectangleDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyView
implements Renderable,
Serializable {
    public ArrayList<MyPage> pages = new ArrayList();
    private boolean drawBorderAndShadow = true;
    private boolean automaticZoomToFitPage = false;
    private MyDocument document;
    private String name;
    private ArtificialLines artificialLines = new ArtificialLines(this);
    private Grid grid = new Grid(this);
    private Borders borders = new Borders(this);

    public MyView(MyDocument document) {
        this.document = document;
    }

    public MyPage addPageDINA4() {
        MyPage page = this.addPage();
        page.setHeightcm(29.7);
        page.setWidthcm(21.0);
        return page;
    }

    public static String getXMLName() {
        return "view";
    }

    public MyPage addPage() {
        MyPage page = new MyPage();
        this.pages.add(page);
        page.setView(this);
        return page;
    }

    public void addPage(MyPage page) {
        this.pages.add(page);
        page.setView(this);
    }

    public double getMaxPageWidth() {
        double maxWidth = 0.0;
        for (MyPage page : this.pages) {
            if (!(page.getWidthcm() > maxWidth)) continue;
            maxWidth = page.getWidthcm();
        }
        return maxWidth;
    }

    public double getMaxPageHeight() {
        double maxHeight = 0.0;
        for (MyPage page : this.pages) {
            if (!(page.getHeightcm() > maxHeight)) continue;
            maxHeight = page.getHeightcm();
        }
        return maxHeight;
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.view;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        return false;
    }

    public MyPage getPage(int number) {
        MyPage page = null;
        try {
            page = this.pages.get(number);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return page;
    }

    public int indexOfPage(MyPage page) {
        return this.pages.indexOf(page);
    }

    @Override
    public RectangleDouble getBoundingBox() {
        return null;
    }

    public CommandManager getCommandManager() {
        return this.document.getCommandManager();
    }

    @Override
    public void deSerialize(Element element) {
        this.name = XMLReader.attributeNotNull(element, "name");
        Boolean b = XMLReader.elementBooleanAttribute(element, "drawborder");
        if (b != null) {
            this.drawBorderAndShadow = b;
        }
        if ((b = XMLReader.elementBooleanAttribute(element, "automaticzoom")) != null) {
            this.automaticZoomToFitPage = b;
        }
        List<Element> elements = XMLReader.elements(element);
        for (Element childElement : elements) {
            if (childElement.getNodeName().compareTo(MyPage.getXMLName()) == 0) {
                MyPage page = new MyPage();
                this.addPage(page);
                page.deSerialize(childElement);
            }
            if (childElement.getNodeName().compareTo(ArtificialLines.getXMLName()) == 0) {
                this.artificialLines.deSerialize(childElement);
            }
            if (childElement.getNodeName().compareTo(Grid.getXMLName()) == 0) {
                this.grid.deSerialize(childElement);
            }
            if (childElement.getNodeName().compareTo(Borders.getXMLName()) != 0) continue;
            this.borders.deSerialize(childElement);
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyView.getXMLName(), parentElement);
        XMLWriter.addAttribute(element, "name", this.name);
        XMLWriter.addAttributeBoolean(element, "drawborder", this.drawBorderAndShadow);
        XMLWriter.addAttributeBoolean(element, "automaticzoom", this.automaticZoomToFitPage);
        for (MyPage page : this.pages) {
            page.serialize(element);
        }
        this.artificialLines.serialize(element);
        this.grid.serialize(element);
        this.borders.serialize(element);
        return element;
    }

    public MyObject getObjectByIndex(int index) {
        return this.document.getObjectByIndex(index);
    }

    public ArrayList<MyPage> getPages() {
        return this.pages;
    }

    public boolean isDrawBorderAndShadow() {
        return this.drawBorderAndShadow;
    }

    public MyDocument getDocument() {
        return this.document;
    }

    public String getName() {
        return this.name;
    }

    public void setDrawBorderAndShadow(boolean drawBorder) {
        this.drawBorderAndShadow = drawBorder;
        this.name = drawBorder ? "Druckansicht" : "Schnelleingabe";
    }

    public boolean isAutomaticZoomToFitPage() {
        return this.automaticZoomToFitPage;
    }

    public void setAutomaticZoomToFitPage(boolean automaticZoomToFitPage) {
        this.automaticZoomToFitPage = automaticZoomToFitPage;
    }

    public ArtificialLines getArtificialLines() {
        return this.artificialLines;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public Borders getBorders() {
        return this.borders;
    }

    public void addPage(MyPage page, int i) {
        this.pages.add(i, page);
        page.setView(this);
    }

    public void removePage(MyPage page) {
        this.pages.remove(page);
        this.setDirty();
    }

    public void switchEditMode(Settings.ToggleEditModus editmode) {
        for (MyPage page : this.pages) {
            page.switchEditMode(editmode);
        }
    }

    public void setDirty() {
        this.document.setDirty(true);
    }

    public MyView getCopy(MyDocument newDocument) {
        MyView copy = new MyView(newDocument);
        copy.artificialLines = this.artificialLines.getCopy(copy);
        copy.automaticZoomToFitPage = this.automaticZoomToFitPage;
        copy.borders = this.borders.getCopy(copy);
        copy.drawBorderAndShadow = this.drawBorderAndShadow;
        copy.grid = this.grid.getCopy(copy);
        copy.name = this.name;
        for (MyPage page : this.pages) {
            copy.addPage(page.getCopy(copy));
        }
        return copy;
    }
}

