/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import commands.RemoveQuickviewCommand;
import document.MyDocument;
import document.view.MyView;
import gui.actions.AddQuickviewAction;
import gui.actions.MyAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;

public class RemoveQuickviewAction
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static RemoveQuickviewAction instance;

    public static RemoveQuickviewAction getInstance() {
        if (instance == null) {
            instance = new RemoveQuickviewAction();
        }
        return instance;
    }

    private RemoveQuickviewAction() {
        super("Schnelleingabeansicht entfernen", "data/img/menu/16/remove_quickview.png");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
        MyDocument document = controller.getDocument();
        RemoveQuickviewCommand command = new RemoveQuickviewCommand(document);
        AddQuickviewAction.getInstance().setEnabled(true);
        this.setEnabled(false);
    }

    public void setEnabledStatus() {
        try {
            PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
            MyDocument document = controller.getDocument();
            MyView quickView = document.getQuickView();
            boolean enabled = quickView != null;
            this.setEnabled(enabled);
        }
        catch (Exception ex) {
            this.setEnabled(false);
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

