/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import document.MyDocument;
import gui.actions.MyAction;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.io.XMLFilter;
import util.xml.XMLWriter;

public class SaveAsAction
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static SaveAsAction instance;

    public static SaveAsAction getInstance() {
        if (instance == null) {
            instance = new SaveAsAction();
        }
        return instance;
    }

    private SaveAsAction() {
        super("Speichern unter...", "data/img/menu/16/filesaveas.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MainPanelController.getInstance().saveCurrentEventScript();
        MyDocument document = controller.getDocument();
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new XMLFilter());
        int returnVal = fc.showSaveDialog(MainPanelController.getInstance().getMainPanel());
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                if (!file.getName().endsWith(".xml")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
                }
                Document doc = XMLWriter.createEmptyDocument();
                Element element = doc.createElement("document");
                doc.appendChild(element);
                document.serialize(element);
                XMLWriter.writeToFile(doc, file);
                document.setFilename(file.getAbsolutePath());
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

