/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport;

import document.MyGroup;
import document.MyObject;
import document.MyPage;
import document.Renderable;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import renderer.g2dRenderer.G2dRenderer;
import util.math.PointInt;

public class PageController {
    private int leftPixel;
    private int topPixel;
    private int rightPixel;
    private int bottomPixel;
    private MyPage page;
    private PageViewPortController pageViewPortController;
    private SnapPositions snapPositions;

    public PageController(MyPage page, PageViewPortController pageViewPortController) {
        this.page = page;
        this.pageViewPortController = pageViewPortController;
        this.snapPositions = new SnapPositions(page);
    }

    public int getBottomPixel() {
        return this.bottomPixel;
    }

    public void setBottomPixel(int bottomPixel) {
        this.bottomPixel = bottomPixel;
    }

    public int getRightPixel() {
        return this.rightPixel;
    }

    public void setRightPixel(int rightPixel) {
        this.rightPixel = rightPixel;
    }

    public int getLeftPixel() {
        return this.leftPixel;
    }

    public int getWidth() {
        return this.rightPixel - this.leftPixel + 1;
    }

    public int getHeight() {
        return this.bottomPixel - this.topPixel + 1;
    }

    public void setLeftPixel(int leftPixel) {
        this.leftPixel = leftPixel;
    }

    public int getTopPixel() {
        return this.topPixel;
    }

    public void setTopPixel(int topPixel) {
        this.topPixel = topPixel;
    }

    public MyPage getPage() {
        return this.page;
    }

    public void setPage(MyPage page) {
        this.page = page;
    }

    public PointInt getTopLeft() {
        return new PointInt(this.leftPixel, this.topPixel);
    }

    public void paint(Graphics2D g2d, boolean onlyBelowMarkedObjects, boolean paintCopyOfMarkedObjects) {
        ViewportGraphicContext vgc = this.pageViewPortController.getPageViewport().getViewPortGraphicContext(this.page, g2d, null);
        vgc.setPageCoordinates(true);
        G2dRenderer renderer = new G2dRenderer(vgc);
        if (onlyBelowMarkedObjects) {
            renderer.renderBelowObject(this.page, paintCopyOfMarkedObjects);
        } else {
            renderer.render(this.page, false);
        }
        vgc.setPanelCoordinates();
    }

    public Rectangle getPageRectangle() {
        Rectangle rectangle = new Rectangle(this.getLeftPixel(), this.getTopPixel(), this.getWidth() - 1, this.getHeight() - 1);
        return rectangle;
    }

    public SnapPositions getSnapPositions() {
        return this.snapPositions;
    }

    public void clearSnapPositions() {
        this.snapPositions.clearPositions();
    }

    public void renewSnapPositions(MyObject excludedObject) {
        this.clearSnapPositions();
        if (excludedObject != null && excludedObject.getType() == Renderable.ObjectType.group) {
            MyGroup group = (MyGroup)excludedObject;
            for (MyObject object : this.page.objects) {
                if (object == excludedObject || group.getObjects().contains(object)) continue;
                object.getSnapPositions(this.snapPositions);
            }
        } else {
            for (MyObject object : this.page.objects) {
                if (object == excludedObject) continue;
                object.getSnapPositions(this.snapPositions);
            }
        }
        this.snapPositions.addPosition(this.page.getWidthcm() / 2.0, 2.0, SnapPositions.Type.horizontalCenter, null);
        this.snapPositions.setEmpty(false);
    }

    public void drawActiveSnapPositions(Graphics2D g2d) {
        this.snapPositions.drawActiveSnapLines(g2d);
    }
}

