/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport;

import document.AbstractKeyboardFocusable;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.paintjobs.PaintJob;
import gui.components.pageviewport.paintjobs.PaintJobPaintAll;
import gui.components.pageviewport.paintjobs.PaintJobPaintAllWithBuffer;
import gui.components.pageviewport.paintjobs.PaintJobPaintTextField;
import gui.components.pageviewport.paintjobs.PaintJobs;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import gui.components.zoomfactor.ZoomFactor;
import init.Settings;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import renderer.g2dRenderer.G2dRenderer;
import util.math.PointDouble;
import util.math.PointInt;

public class PageViewport
extends JPanel
implements ComponentListener,
MouseInputListener,
KeyListener,
FocusListener {
    private PaintJobs paintJobs = new PaintJobs();
    private PageViewPortController controller;
    private ZoomFactor zoomFactor = new ZoomFactor(1.0);
    private Color backgroundColor;
    private static BufferedImage bufferedImageBelow = null;
    private static BufferedImage bufferedImageAbove = null;
    private Rectangle visiblePageRectangle;
    private Rectangle visibleRectangle;
    private double screenResolutioncm;
    private boolean isProgramPaint;
    private boolean forceFullRepaint = false;
    private boolean bufferIsFresh = true;
    private static BufferedImage focusBackBuffer = null;
    private Rectangle bufferRectangle = new Rectangle();
    private boolean isOldObjectBuffer = false;

    public PointDouble pixelTocm(PointInt p) {
        return p.mult(1.0 / (this.screenResolutioncm * this.zoomFactor.getFactor()));
    }

    public double pixelTocmX(int pixel) {
        return (double)pixel / (this.screenResolutioncm * this.zoomFactor.getFactor());
    }

    public double pixelTocmY(int pixel) {
        return (double)pixel / (this.screenResolutioncm * this.zoomFactor.getFactor());
    }

    public PointInt cmtoPixel(PointDouble p) {
        p.mult(this.screenResolutioncm * this.zoomFactor.getFactor());
        return p.round();
    }

    public int cmXtoPixel(double cmx) {
        return (int)Math.round(cmx * this.screenResolutioncm * this.zoomFactor.getFactor());
    }

    public int cmYtoPixel(double cmy) {
        return (int)Math.round(cmy * this.screenResolutioncm * this.zoomFactor.getFactor());
    }

    public int pageCmXtoPixel(double cmx, MyPage page) {
        return (int)Math.round(cmx * this.screenResolutioncm * this.zoomFactor.getFactor()) + this.controller.getPageController(page).getLeftPixel();
    }

    public int pageCmYtoPixel(double cmy, MyPage page) {
        return (int)Math.round(cmy * this.screenResolutioncm * this.zoomFactor.getFactor()) + this.controller.getPageController(page).getTopPixel();
    }

    public PointDouble pageCmToPixel(PointDouble p, MyPage page) {
        return new PointDouble(this.pageCmXtoPixel(p.x, page), this.pageCmYtoPixel(p.y, page));
    }

    public PointInt screenCmtoPixel(PointDouble p) {
        p.mult(this.screenResolutioncm);
        return p.round();
    }

    public int screenCmToPixelX(double screenCm) {
        return (int)Math.round(screenCm * this.screenResolutioncm);
    }

    public int screenCmToPixelY(double screenCm) {
        return (int)Math.round(screenCm * this.screenResolutioncm);
    }

    public PageViewport(PageViewPortController controller) {
        this.controller = controller;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setBackgroundColor(Color.gray);
        this.setFocusTraversalKeysEnabled(false);
    }

    public void setSizeXY(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
    }

    public void paintShadow(PageController pc, int thickness, Graphics2D g2d) {
        int left = pc.getLeftPixel();
        int right = pc.getRightPixel();
        int top = pc.getTopPixel();
        int bottom = pc.getBottomPixel();
        g2d.setColor(Color.black);
        g2d.fillRect(left + thickness, top - thickness, right - left, thickness);
        g2d.fillRect(right + 1, top, thickness - 1, bottom - top - thickness);
    }

    public void paintPageBackground(PageController pc, Graphics2D g2d) {
        int left = pc.getLeftPixel();
        int right = pc.getRightPixel();
        int top = pc.getTopPixel();
        int bottom = pc.getBottomPixel();
        g2d.setColor(Color.white);
        g2d.fillRect(left, top, right - left, bottom - top);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.black);
        g2d.drawRect(left - 1, top - 1, right - left + 1, bottom - top + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics g1 = null;
        try {
            g1 = g.create();
            PaintJobs paintJobs = this.paintJobs;
            synchronized (paintJobs) {
                this.controller.getCursorController().timerStop();
                if (!this.isProgramPaint) {
                    boolean repaintAllIsThere = false;
                    for (PaintJob job : this.paintJobs) {
                        if (!(job instanceof PaintJobPaintAll) && !(job instanceof PaintJobPaintAllWithBuffer)) continue;
                        repaintAllIsThere = true;
                        break;
                    }
                    if (!repaintAllIsThere) {
                        this.addJob(PaintJobPaintAllWithBuffer.getInstance());
                    }
                }
                Graphics2D g2d = (Graphics2D)g1;
                AffineTransform at = g2d.getTransform();
                if (this.paintJobs.size() > 0) {
                    while (this.paintJobs.size() > 0) {
                        PaintJob job = (PaintJob)this.paintJobs.removeLast();
                        job.execute(this, g2d);
                    }
                } else {
                    this.paintWholeViewportWithHandles(g2d);
                }
                g2d.setTransform(at);
                this.controller.getCursorController().timerStart();
                this.isProgramPaint = false;
            }
        }
        finally {
            g1.dispose();
        }
    }

    public void paintWholeViewPortWithHandlesWithoutBuffer(Graphics2D g2d) {
        this.visibleRectangle = this.controller.getPageScrollPaneController().getVisibleRectangle();
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(this.visibleRectangle.x, this.visibleRectangle.y, this.visibleRectangle.width, this.visibleRectangle.height);
        this.controller.paintAllVisiblePages(g2d, false, true);
        if (this.controller.getStateInfo().getKeyboardFocusableObject() != null) {
            this.forceFullRepaint = true;
            AbstractKeyboardFocusable kf = this.controller.getStateInfo().getKeyboardFocusableObject();
            PaintJobPaintTextField job = new PaintJobPaintTextField(kf, this.controller, false, false, false);
            job.execute(this, g2d);
        }
        this.controller.drawIcons(g2d);
        this.controller.drawHandles(g2d);
        this.controller.updateCursor(false);
    }

    public void paintWholeViewportWithHandles(Graphics2D g2d) {
        if (this.controller.getStateInfo().getKeyboardFocusableObject() != null) {
            this.forceFullRepaint = true;
            AbstractKeyboardFocusable kf = this.controller.getStateInfo().getKeyboardFocusableObject();
            PaintJobPaintTextField job = new PaintJobPaintTextField(kf, this.controller, true, false, true);
            job.execute(this, g2d);
        } else {
            this.paintAllWithBuffer(g2d);
        }
        this.controller.drawIcons(g2d);
        this.controller.drawHandles(g2d);
        this.controller.updateCursor(false);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.controller.viewPortResized();
        this.invalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        PointInt p = new PointInt(e.getX(), e.getY());
        switch (e.getButton()) {
            case 1: {
                this.controller.getState().mouseLeftDown(e, this.makeMouseDocumentInfo(p));
                break;
            }
            case 3: {
                this.controller.getState().mouseRightDown(e, this.makeMouseDocumentInfo(p));
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        PointInt p = new PointInt(e.getX(), e.getY());
        switch (e.getButton()) {
            case 1: {
                this.controller.getState().mouseLeftUp(e, this.makeMouseDocumentInfo(p));
                break;
            }
            case 3: {
                this.controller.getState().mouseRightUp(e, this.makeMouseDocumentInfo(p));
                break;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        PointInt p = new PointInt(e.getX(), e.getY());
        this.controller.getState().mouseMoved(e, this.makeMouseDocumentInfo(p));
    }

    public MouseDocumentInfo makeMouseDocumentInfo(PointInt p) {
        MouseDocumentInfo info = new MouseDocumentInfo(this.controller, this.pixelTocmX(AbstractKeyboardFocusable.getPickWidthPixel()));
        info.setPanelPoint(p);
        info.setHandle(this.controller.handleUnderCursor(p));
        if (info.getHandle() == null) {
            info.setPage(this.controller.pageUnderCursor(p));
        } else {
            info.setPage(info.getHandle().getOriginalObject().getPage());
        }
        if (info.getPage() != null) {
            info.setPagePoint(this.controller.pixelToPageCm(p, info.getPage()));
            info.setObject(this.controller.objectUnderCursor(p, info.getPage()));
        } else {
            info.setPagePoint(new PointDouble(-1.0, -1.0));
        }
        return info;
    }

    public void beginMouseMove(boolean paintCopyOfOriginalObjects) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        this.visibleRectangle = this.controller.getPageScrollPaneController().getVisibleRectangle();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (bufferedImageBelow == null || bufferedImageBelow.getWidth() != this.visibleRectangle.width || bufferedImageBelow.getHeight() != this.visibleRectangle.height) {
            bufferedImageBelow = gc.createCompatibleImage(this.visibleRectangle.width, this.visibleRectangle.height);
        }
        Graphics2D g2Below = bufferedImageBelow.createGraphics();
        g2Below.setColor(this.backgroundColor);
        g2Below.fillRect(0, 0, this.visibleRectangle.width, this.visibleRectangle.height);
        g2Below.translate((double)(-this.visibleRectangle.x), (double)(-this.visibleRectangle.y));
        this.controller.paintAllVisiblePages(g2Below, stateInfo.getObjectToDraw() == null, paintCopyOfOriginalObjects);
        g2Below.translate((double)this.visibleRectangle.x, (double)this.visibleRectangle.y);
        if (stateInfo.getObjectToDraw() == null && stateInfo.getMarkedObjects().size() > 0) {
            MyPage page = stateInfo.getMarkedObjects().getPage();
            PageController pc = this.controller.getPageController(page);
            this.visiblePageRectangle = this.visibleRectangle.intersection(pc.getPageRectangle());
            int width = this.visiblePageRectangle.width;
            int height = this.visiblePageRectangle.height;
            if (bufferedImageAbove == null || bufferedImageAbove.getWidth() != width || bufferedImageAbove.getHeight() != height) {
                bufferedImageAbove = gc.createCompatibleImage(width, height, 3);
            }
            Graphics2D g2Above = bufferedImageAbove.createGraphics();
            g2Above.setColor(Color.white);
            g2Above.setComposite(AlphaComposite.Clear);
            g2Above.fillRect(0, 0, width, height);
            g2Above.setComposite(AlphaComposite.SrcOver);
            int left = 0;
            int top = 0;
            left = this.visiblePageRectangle.x - pc.getLeftPixel();
            top = this.visiblePageRectangle.y - pc.getTopPixel();
            ViewportGraphicContext vgc = null;
            vgc = new ViewportGraphicContext(this.getScreenResolutioncm(), this.zoomFactor.getFactor(), -left, -top, page.getWidthcm(), page.getHeightcm(), g2Above, null);
            g2Above.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2Above.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            G2dRenderer renderer = new G2dRenderer(vgc);
            renderer.renderAboveObject(page);
            vgc.setPanelCoordinates();
        }
    }

    public boolean isOldObjectBuffer() {
        return this.isOldObjectBuffer;
    }

    public ViewportGraphicContext getObjectBufferContext(MyObject object) {
        boolean isUpperPart;
        Rectangle objectRectPanel;
        boolean isRotated;
        MyPage page = object.getPage();
        boolean bl = isRotated = Math.abs(object.getAngle()) > 1.0E-6;
        if (isRotated) {
            objectRectPanel = this.controller.getPanelRect(object);
        } else {
            Rectangle2D objectRect = object.getRealSizeRectangle();
            int widthPixel = this.cmXtoPixel(objectRect.getWidth());
            int heightPixel = this.cmYtoPixel(objectRect.getHeight());
            double midXcm = (objectRect.getMinX() + objectRect.getMaxX()) / 2.0;
            double midYcm = (objectRect.getMinY() + objectRect.getMaxY()) / 2.0;
            PointDouble p = new PointDouble(midXcm, midYcm);
            p = this.pageCmToPixel(p, page);
            objectRectPanel = new Rectangle((int)(p.x - (double)(widthPixel / 2)), (int)(p.y - (double)(heightPixel / 2)), widthPixel, heightPixel);
        }
        this.visibleRectangle = this.controller.getPageScrollPaneController().getVisibleRectangle();
        Rectangle newBufferRectangle = objectRectPanel.intersection(this.visibleRectangle);
        this.isOldObjectBuffer = isUpperPart = focusBackBuffer != null && newBufferRectangle.x == this.bufferRectangle.x && Math.abs(newBufferRectangle.y - this.bufferRectangle.y) < 3 && focusBackBuffer.getWidth() == newBufferRectangle.width && newBufferRectangle.height <= focusBackBuffer.getHeight();
        this.bufferRectangle = newBufferRectangle;
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (focusBackBuffer == null || (double)focusBackBuffer.getWidth() != this.bufferRectangle.getWidth() || (double)focusBackBuffer.getHeight() != this.bufferRectangle.getHeight()) {
            BufferedImage newBuffer;
            if (!isUpperPart) {
                newBuffer = this.bufferRectangle.width > 0 && this.bufferRectangle.height > 0 ? gc.createCompatibleImage(this.bufferRectangle.width, this.bufferRectangle.height) : gc.createCompatibleImage(1, 1);
            } else {
                if (this.bufferRectangle.height > focusBackBuffer.getHeight()) {
                    this.bufferRectangle.height = focusBackBuffer.getHeight();
                }
                newBuffer = focusBackBuffer.getSubimage(0, 0, focusBackBuffer.getWidth(), this.bufferRectangle.height);
            }
            focusBackBuffer = newBuffer;
        }
        Graphics2D g2d = (Graphics2D)focusBackBuffer.getGraphics();
        PageController pc = this.controller.getPageController(page);
        int left = this.bufferRectangle.x - pc.getLeftPixel();
        int top = this.bufferRectangle.y - pc.getTopPixel();
        ViewportGraphicContext vgc = new ViewportGraphicContext(this.getScreenResolutioncm(), this.zoomFactor.getFactor(), -left, -top, page.getWidthcm(), page.getHeightcm(), g2d, null);
        return vgc;
    }

    public void restoreBackgroudFromObjectBuffer(Rectangle r, Graphics2D g2d) {
        int left = r.x - this.bufferRectangle.x;
        int top = r.y - this.bufferRectangle.y;
        if (left > 0 && top > 0 && left < this.bufferRectangle.width && top < this.bufferRectangle.height) {
            if (top + r.height > this.bufferRectangle.height) {
                r.height = this.bufferRectangle.height - top;
            }
            if (left + r.width > this.bufferRectangle.width) {
                r.width = this.bufferRectangle.width - left;
            }
            if (focusBackBuffer != null && focusBackBuffer.getWidth() > 0 && focusBackBuffer.getHeight() > 0) {
                BufferedImage patch = focusBackBuffer.getSubimage(left, top, r.width, r.height);
                g2d.drawImage((Image)patch, r.x, r.y, null);
            }
        }
    }

    public void flushObjectBuffer(Graphics2D g2d, MyObject object) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.drawImage((Image)focusBackBuffer, this.bufferRectangle.x, this.bufferRectangle.y, null);
    }

    public void mouseMoveUpdateDrawNew(Graphics2D g2d) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        MyPage page = stateInfo.getMarkedObjects().getPage();
        MyObject objectToDraw = this.controller.getStateInfo().getObjectToDraw();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.drawImage((Image)bufferedImageBelow, this.visibleRectangle.x, this.visibleRectangle.y, null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (objectToDraw != null) {
            page = objectToDraw.getPage();
            PageController pc = this.controller.getPageController(page);
            ViewportGraphicContext vgc = new ViewportGraphicContext(this.getScreenResolutioncm(), this.zoomFactor.getFactor(), pc.getLeftPixel(), pc.getTopPixel(), page.getWidthcm(), page.getHeightcm(), g2d, null);
            G2dRenderer renderer = new G2dRenderer(vgc);
            vgc.setPageCoordinates(false);
            renderer.render(objectToDraw, true);
            vgc.setPanelCoordinates();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        } else if (stateInfo.getMarkedObjects().size() > 0) {
            page = stateInfo.getMarkedObjects().getPage();
            PageController pc = this.controller.getPageController(page);
            ViewportGraphicContext vgc = new ViewportGraphicContext(this.getScreenResolutioncm(), this.zoomFactor.getFactor(), pc.getLeftPixel(), pc.getTopPixel(), page.getWidthcm(), page.getHeightcm(), g2d, null);
            G2dRenderer renderer = new G2dRenderer(vgc);
            renderer.renderPreviewObjects(page);
            vgc.setPanelCoordinates();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2d.drawImage((Image)bufferedImageAbove, this.visiblePageRectangle.x, this.visiblePageRectangle.y, null);
        }
        this.controller.drawActiveSnapPositions(g2d);
    }

    public void setScreenResolution() {
        this.screenResolutioncm = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54;
    }

    public double getScreenResolutioncm() {
        return this.screenResolutioncm;
    }

    public ZoomFactor getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(ZoomFactor zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.controller.getState().ESCpressed();
        } else {
            this.controller.getState().keyboardpressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.controller.getState().keyTyped(e);
    }

    public PageViewPortController getController() {
        return this.controller;
    }

    public Graphics2D paintObjectToBufferPrepareBuffer(Graphics2D g2d) {
        if (bufferedImageBelow == null || this.forceFullRepaint) {
            this.forceFullRepaint = false;
            this.paintAllFillBuffer();
        }
        Graphics2D g2Below = bufferedImageBelow.createGraphics();
        g2Below.translate((double)(-this.visibleRectangle.x), (double)(-this.visibleRectangle.y));
        return g2Below;
    }

    public void paintObjectToBufferFlushBuffer(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.drawImage((Image)bufferedImageBelow, this.visibleRectangle.x, this.visibleRectangle.y, null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public void paintAllFillBuffer() {
        this.visibleRectangle = this.controller.getPageScrollPaneController().getVisibleRectangle();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (bufferedImageBelow == null || bufferedImageBelow.getWidth() != this.visibleRectangle.width || bufferedImageBelow.getHeight() != this.visibleRectangle.height) {
            bufferedImageBelow = gc.createCompatibleImage(this.visibleRectangle.width, this.visibleRectangle.height, 1);
        }
        Graphics2D g2Below = bufferedImageBelow.createGraphics();
        g2Below.setColor(this.backgroundColor);
        g2Below.fillRect(0, 0, this.visibleRectangle.width, this.visibleRectangle.height);
        g2Below.translate((double)(-this.visibleRectangle.x), (double)(-this.visibleRectangle.y));
        this.bufferIsFresh = true;
        this.controller.paintAllVisiblePages(g2Below, false, true);
        this.bufferIsFresh = false;
        g2Below.translate((double)this.visibleRectangle.x, (double)this.visibleRectangle.y);
    }

    public void paintAllWithBuffer(Graphics2D g2d) {
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle clipRect = g2d.getClipBounds();
        if (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit && bufferedImageBelow != null && (clipRect.width == visibleRect.width && (double)(clipRect.height / visibleRect.height) < 0.5 || clipRect.height == visibleRect.height && (double)(clipRect.width / visibleRect.width) < 0.5)) {
            this.paintAllFillBuffer();
        } else {
            this.paintAllFillBuffer();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.drawImage((Image)bufferedImageBelow, this.visibleRectangle.x, this.visibleRectangle.y, null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public void repaintRectangleWithBackgroundimage(Rectangle r, Graphics2D g2d) {
        if (bufferedImageBelow != null && !this.bufferIsFresh) {
            BufferedImage subImage;
            this.visibleRectangle = this.controller.getPageScrollPaneController().getVisibleRectangle();
            int x = r.x - this.visibleRectangle.x;
            int y = r.y - this.visibleRectangle.y;
            int width = r.width;
            int height = r.height;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + width > bufferedImageBelow.getWidth()) {
                width = bufferedImageBelow.getWidth() - x;
            }
            if (y + height > bufferedImageBelow.getHeight()) {
                height = bufferedImageBelow.getHeight() - y;
            }
            try {
                subImage = bufferedImageBelow.getSubimage(x, y, width, height);
            }
            catch (Exception e) {
                subImage = null;
            }
            if (subImage != null) {
                g2d.drawImage((Image)subImage, r.x, r.y, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJob(PaintJob job) {
        PaintJobs paintJobs = this.paintJobs;
        synchronized (paintJobs) {
            return this.paintJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobs() {
        PaintJobs paintJobs = this.paintJobs;
        synchronized (paintJobs) {
            this.paintJobs.clear();
        }
    }

    public ViewportGraphicContext getViewPortGraphicContext(MyPage page, Graphics2D g2d, Rectangle boundsRect) {
        PageController pc = this.controller.getPageController(page);
        ViewportGraphicContext vgc = new ViewportGraphicContext(this.getScreenResolutioncm(), this.zoomFactor.getFactor(), pc.getLeftPixel(), pc.getTopPixel(), page.getWidthcm(), page.getHeightcm(), g2d, boundsRect);
        return vgc;
    }

    public PaintJobs getPaintJobs() {
        return this.paintJobs;
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        this.isProgramPaint = true;
        super.paintImmediately(x, y, w, h);
    }

    public boolean isForceFullRepaint() {
        return this.forceFullRepaint;
    }

    public void setForceFullRepaint(boolean forceFullRepaint) {
        this.forceFullRepaint = forceFullRepaint;
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        super.repaint(x, y, width, height);
    }

    @Override
    public void repaint(Rectangle r) {
        super.repaint(r);
    }

    @Override
    public void focusGained(FocusEvent e) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        if (stateInfo.getKeyboardFocusableObject() != null) {
            this.controller.getCursorController().setEnabled(true);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        if (stateInfo.getKeyboardFocusableObject() != null) {
            this.controller.getCursorController().addLastClearJobAndSetDisabled();
            this.repaint();
        }
    }
}

