/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.autoarrange;

import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.autoarrange.SnapPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import util.math.PointDouble;

public class SnapPositions {
    private ArrayList<SnapPosition> horizontalPositions = new ArrayList();
    private ArrayList<SnapPosition> horizontalCenters = new ArrayList();
    private ArrayList<SnapPosition> verticalPositions = new ArrayList();
    private ArrayList<SnapPosition> verticalCenters = new ArrayList();
    private ArrayList<SnapPosition> points = new ArrayList();
    private ArrayList<SnapPosition> activePositions = new ArrayList();
    private MyPage page;
    private boolean empty = true;

    public SnapPositions(MyPage page) {
        this.page = page;
    }

    public void addPosition(double x, double y, Type type, MyObject object) {
        this.empty = false;
        SnapPosition position = new SnapPosition(x, y, type, object);
        switch (type) {
            case horizontal: {
                this.horizontalPositions.add(position);
                break;
            }
            case horizontalCenter: {
                this.horizontalCenters.add(position);
                break;
            }
            case vertical: {
                this.verticalPositions.add(position);
                break;
            }
            case verticalCenter: {
                this.verticalCenters.add(position);
                break;
            }
            case point: {
                this.points.add(position);
                break;
            }
        }
    }

    public void clearPositions() {
        this.horizontalPositions.clear();
        this.horizontalCenters.clear();
        this.verticalPositions.clear();
        this.verticalCenters.clear();
        this.activePositions.clear();
        this.points.clear();
        this.empty = true;
    }

    public SnapPosition isNearPosition(PointDouble point, double maxDistance, Type type) {
        SnapPosition foundPosition = null;
        ArrayList<SnapPosition> list = this.horizontalPositions;
        block0 : switch (type) {
            case horizontal: {
                list = this.horizontalPositions;
                for (SnapPosition position : list) {
                    if (!(Math.abs(position.x - point.x) <= maxDistance)) continue;
                    foundPosition = position;
                    break block0;
                }
                break;
            }
            case vertical: {
                list = this.verticalPositions;
                for (SnapPosition position : list) {
                    if (!(Math.abs(position.y - point.y) <= maxDistance)) continue;
                    foundPosition = position;
                    break block0;
                }
                break;
            }
            case horizontalCenter: {
                list = this.horizontalCenters;
                for (SnapPosition position : list) {
                    if (!(Math.abs(position.x - point.x) <= maxDistance)) continue;
                    foundPosition = position;
                    break block0;
                }
                break;
            }
            case verticalCenter: {
                list = this.verticalCenters;
                for (SnapPosition position : list) {
                    if (!(Math.abs(position.y - point.y) <= maxDistance)) continue;
                    foundPosition = position;
                    break block0;
                }
                break;
            }
            case point: {
                list = this.points;
                for (SnapPosition position : list) {
                    if (!(position.distance(point) <= maxDistance)) continue;
                    foundPosition = position;
                    break block0;
                }
                break;
            }
        }
        if (foundPosition != null) {
            this.activePositions.add(foundPosition);
        }
        return foundPosition;
    }

    public void clearActivePositions() {
        this.activePositions.clear();
    }

    public void deletePositionsOfObject(MyObject object) {
        this.deletePositionsOfObjectInList(object, this.horizontalPositions);
        this.deletePositionsOfObjectInList(object, this.horizontalCenters);
        this.deletePositionsOfObjectInList(object, this.verticalPositions);
        this.deletePositionsOfObjectInList(object, this.verticalCenters);
        this.deletePositionsOfObjectInList(object, this.points);
        this.deletePositionsOfObjectInList(object, this.activePositions);
    }

    private void deletePositionsOfObjectInList(MyObject object, ArrayList<SnapPosition> list) {
        int i = 0;
        while (i < list.size()) {
            if (list.get((int)i).object == object) {
                list.remove(i);
            } else {
                ++i;
            }
            ++i;
        }
    }

    public void drawActiveSnapLines(Graphics2D g2d) {
        float pixelWidth;
        AffineTransform at = g2d.getTransform();
        Stroke stroke = g2d.getStroke();
        float width = pixelWidth = (float)(1.0 / at.getScaleX());
        float[] dashs = new float[]{pixelWidth * 2.0f, pixelWidth * 1.0f};
        float[] dashpoints = new float[]{pixelWidth * 6.0f, pixelWidth * 3.0f, pixelWidth * 2.0f, pixelWidth * 3.0f};
        BasicStroke strokeDashed = new BasicStroke(width, 0, 0, 1.0f, dashs, 0.0f);
        BasicStroke strokeDashPointed = new BasicStroke(width, 0, 0, 1.0f, dashpoints, 0.0f);
        g2d.setColor(Color.black);
        for (SnapPosition snapPosition : this.activePositions) {
            switch (snapPosition.type) {
                case vertical: {
                    g2d.setStroke(strokeDashed);
                    Line2D.Double line = new Line2D.Double(0.0, snapPosition.y, this.page.getWidthcm(), snapPosition.y);
                    g2d.draw(line);
                    break;
                }
                case horizontal: {
                    g2d.setStroke(strokeDashed);
                    Line2D.Double line = new Line2D.Double(snapPosition.x, 0.0, snapPosition.x, this.page.getHeightcm());
                    g2d.draw(line);
                    break;
                }
                case verticalCenter: {
                    g2d.setStroke(strokeDashPointed);
                    Line2D.Double line = new Line2D.Double(0.0, snapPosition.y, this.page.getWidthcm(), snapPosition.y);
                    g2d.draw(line);
                    break;
                }
                case horizontalCenter: {
                    g2d.setStroke(strokeDashPointed);
                    Line2D.Double line = new Line2D.Double(snapPosition.x, 0.0, snapPosition.x, this.page.getHeightcm());
                    g2d.draw(line);
                    break;
                }
                case point: {
                    Ellipse2D.Double ellipse = new Ellipse2D.Double(snapPosition.x, snapPosition.y, pixelWidth * 3.0f, pixelWidth * 3.0f);
                    g2d.draw(ellipse);
                    break;
                }
            }
        }
        g2d.setStroke(stroke);
    }

    public boolean hasActiveSnapPositions() {
        return this.activePositions.size() > 0;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean snapPoint(PointDouble positionToSnap, PointDouble pointToMove, Type type, double maxDistance) {
        SnapPosition position = this.isNearPosition(positionToSnap, maxDistance, type);
        if (position != null) {
            switch (type) {
                case horizontal: 
                case horizontalCenter: {
                    double dx = position.x - positionToSnap.x;
                    pointToMove.x += dx;
                    break;
                }
                case vertical: 
                case verticalCenter: {
                    double dy = position.y - positionToSnap.y;
                    pointToMove.y += dy;
                }
            }
        }
        return position != null;
    }

    public static enum Type {
        horizontal,
        horizontalCenter,
        vertical,
        verticalCenter,
        point;

    }
}

