/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.graphiccontext;

import java.awt.Toolkit;
import java.awt.font.LineMetrics;

public class LineMetricsCm
extends LineMetrics {
    private static float dpi = Toolkit.getDefaultToolkit().getScreenResolution();
    private static float cmPerTypographicalPoint = 0.6096f / dpi;
    private LineMetrics lm;

    public LineMetricsCm(LineMetrics lm) {
        this.lm = lm;
    }

    @Override
    public float getAscent() {
        return this.lm.getAscent() * cmPerTypographicalPoint;
    }

    @Override
    public int getBaselineIndex() {
        return this.lm.getBaselineIndex();
    }

    @Override
    public float[] getBaselineOffsets() {
        float[] bo = this.lm.getBaselineOffsets();
        float[] bocm = new float[bo.length];
        int i = 0;
        while (i < bocm.length) {
            int n = i++;
            bocm[n] = bocm[n] * cmPerTypographicalPoint;
        }
        return bocm;
    }

    @Override
    public float getDescent() {
        return this.lm.getDescent() * cmPerTypographicalPoint;
    }

    @Override
    public float getHeight() {
        return this.lm.getHeight() * cmPerTypographicalPoint;
    }

    @Override
    public float getLeading() {
        return this.lm.getLeading() * cmPerTypographicalPoint;
    }

    @Override
    public int getNumChars() {
        return this.lm.getNumChars();
    }

    @Override
    public float getStrikethroughOffset() {
        return this.lm.getStrikethroughOffset() * cmPerTypographicalPoint;
    }

    @Override
    public float getStrikethroughThickness() {
        return this.lm.getStrikethroughThickness() * cmPerTypographicalPoint;
    }

    @Override
    public float getUnderlineOffset() {
        return this.lm.getUnderlineOffset() * cmPerTypographicalPoint;
    }

    @Override
    public float getUnderlineThickness() {
        return this.lm.getUnderlineThickness() * cmPerTypographicalPoint;
    }
}

