/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.graphiccontext;

import gui.components.pageviewport.graphiccontext.GraphicContext;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import util.math.PointDouble;
import util.math.PointInt;

public class PrinterGraphicContext
extends GraphicContext {
    private double zoomfactor = 1.0;
    private double dotsPerCm;
    private int pageOffsetX = 0;
    private int pageOffsetY = 0;
    private double pageWidthCm;
    private double pageHeightCm;
    private Shape oldClip;
    private AffineTransform printerTransform;
    private AffineTransform pageTransform;
    private AffineTransform objectTransform = null;
    double width;
    double height;
    double midX;
    double midY;
    double angle;

    public PrinterGraphicContext(double dotsPerCm, double zoomfactor, int pageOffsetX, int pageOffsetY, double pageWidthCm, double pageHeightCm, Graphics2D g2d) {
        super(g2d);
        this.zoomfactor = zoomfactor;
        this.pageOffsetX = pageOffsetX;
        this.pageOffsetY = pageOffsetY;
        this.dotsPerCm = dotsPerCm;
        this.pageHeightCm = pageHeightCm;
        this.pageWidthCm = pageWidthCm;
        this.oldClip = g2d.getClip();
        this.printerTransform = g2d.getTransform();
        this.pageTransform = g2d.getTransform();
        double factor = dotsPerCm * zoomfactor;
        this.pageTransform.scale(factor, factor);
        this.pageTransform.translate((double)pageOffsetX / factor, (double)pageOffsetY / factor);
    }

    @Override
    public void setObjectMetrics(double midX, double midY, double angle, double width, double height) {
        this.width = width;
        this.height = height;
        this.midX = midX;
        this.midY = midY;
        this.angle = angle;
        this.objectTransform = new AffineTransform(this.printerTransform);
        double factor = this.dotsPerCm * this.zoomfactor;
        this.objectTransform.scale(factor, factor);
        this.objectTransform.translate((double)this.pageOffsetX / factor, (double)this.pageOffsetY / factor);
        this.objectTransform.rotate(-angle, midX, midY);
        this.objectTransform.translate(midX - width / 2.0, midY - height / 2.0);
    }

    public double getZoomfactor() {
        return this.zoomfactor;
    }

    @Override
    public double getDotsPerCm() {
        return this.dotsPerCm;
    }

    public int getPageOffsetX() {
        return this.pageOffsetX;
    }

    public int getPageOffsetY() {
        return this.pageOffsetY;
    }

    @Override
    public boolean isPrinter() {
        return true;
    }

    public void setPrinterCoordinates() {
        this.g2d.setTransform(this.printerTransform);
        this.g2d.setClip(this.oldClip);
        this.coordinateSystem = GraphicContext.CoordinateSystem.panel;
    }

    public PointInt PageToPrinter(PointDouble p) {
        double factor = this.dotsPerCm * this.zoomfactor;
        PointInt pint = new PointInt((int)Math.round(p.getX() * factor + (double)this.pageOffsetX), (int)Math.round(p.getY() * factor + (double)this.pageOffsetY));
        return pint;
    }

    @Override
    public void setObjectCoordinates() {
        this.g2d.setTransform(this.objectTransform);
        this.coordinateSystem = GraphicContext.CoordinateSystem.object;
    }

    @Override
    public void setPageCoordinates(boolean clipped) {
        this.g2d.setTransform(this.printerTransform);
        this.g2d.setClip(this.oldClip);
        this.g2d.setTransform(this.pageTransform);
        if (clipped) {
            Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, this.pageWidthCm, this.pageHeightCm);
            this.g2d.clip(r2d);
        }
        this.coordinateSystem = GraphicContext.CoordinateSystem.page;
    }

    @Override
    public int pageCmToPixel(double cm) {
        double factor = this.dotsPerCm * this.zoomfactor;
        return (int)Math.round(cm * factor);
    }

    @Override
    public double pixelToPageCm(int pixel) {
        double factor = this.dotsPerCm * this.zoomfactor;
        return (double)pixel / factor;
    }

    public PointDouble PrinterToPage(PointInt p) {
        double factor = this.dotsPerCm * this.zoomfactor;
        PointDouble pdouble = new PointDouble((double)(p.getX() - this.pageOffsetX) / factor, (double)(p.getY() - this.pageOffsetY) / factor);
        return pdouble;
    }

    @Override
    public void drawString(String str, float x, float y) {
        AffineTransform oldTransform = this.g2d.getTransform();
        AffineTransform transformToPanel = this.g2d.getTransform();
        Point2D.Float p = new Point2D.Float(x, y);
        Point2D.Float pPanel = new Point2D.Float();
        transformToPanel.transform(p, pPanel);
        try {
            AffineTransform invprinter = this.printerTransform.createInverse();
            invprinter.transform(pPanel, pPanel);
        }
        catch (Exception invprinter) {
            // empty catch block
        }
        AffineTransform at = (AffineTransform)this.printerTransform.clone();
        if (this.coordinateSystem == GraphicContext.CoordinateSystem.object) {
            at.rotate(-this.angle, ((Point2D)pPanel).getX(), ((Point2D)pPanel).getY());
        }
        this.g2d.setTransform(at);
        this.g2d.drawString(str, (float)((Point2D)pPanel).getX(), (float)((Point2D)pPanel).getY());
        this.g2d.setTransform(oldTransform);
    }

    @Override
    public void setPageCoordinates() {
        this.g2d.setTransform(this.pageTransform);
        this.coordinateSystem = GraphicContext.CoordinateSystem.page;
    }
}

