/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.paintjobs;

import document.AbstractKeyboardFocusable;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.paintjobs.PaintJob;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class PaintJobDrawCursor
extends PaintJob {
    private static boolean lastPaintBlack = false;
    private boolean isBlack;
    float x1;
    float x2;
    float y1;
    float y2;
    float width;

    public PaintJobDrawCursor(float x1, float y1, float x2, float y2, float width, boolean isBlack) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.width = width;
        this.isBlack = isBlack;
    }

    public static boolean isLastPaintBlack() {
        return lastPaintBlack;
    }

    @Override
    public void execute(PageViewport pageViewPort, Graphics2D g2d) {
        AbstractKeyboardFocusable kf = pageViewPort.getController().getStateInfo().getKeyboardFocusableObject();
        if (kf == null || Math.abs(kf.getAngle()) < 1.0E-6) {
            Rectangle clipRect = g2d.getClipBounds();
            pageViewPort.restoreBackgroudFromObjectBuffer(clipRect, g2d);
            if (this.isBlack) {
                Line2D.Float line = new Line2D.Float(this.x1, this.y1, this.x2, this.y2);
                g2d.setColor(Color.black);
                g2d.setStroke(new BasicStroke(this.width));
                g2d.draw(line);
            }
        } else {
            g2d.setXORMode(Color.white);
            g2d.setColor(Color.black);
            g2d.setStroke(new BasicStroke(this.width));
            Line2D.Float line = new Line2D.Float(this.x1, this.y1, this.x2, this.y2);
            g2d.draw(line);
            g2d.setPaintMode();
        }
        lastPaintBlack = this.isBlack;
    }

    public String toString() {
        return "DrawCursor";
    }

    public static void setLastPaintBlack(boolean b) {
        lastPaintBlack = b;
    }
}

