/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.paintjobs;

import document.AbstractKeyboardFocusable;
import document.MyPage;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.paintjobs.PaintJob;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import util.graphics.MyGraphics;
import util.math.PointDouble;

public class PaintJobPaintTabArrows
extends PaintJob {
    private AbstractKeyboardFocusable akfSource;
    private AbstractKeyboardFocusable akfDest;
    private PointDouble mousePos;
    PageViewPortController controller;
    boolean prepareBuffer;

    public PaintJobPaintTabArrows(AbstractKeyboardFocusable akfSource, AbstractKeyboardFocusable akfDest, PointDouble mousePos, PageViewPortController controller, boolean prepareBuffer) {
        this.akfSource = akfSource;
        this.akfDest = akfDest;
        this.mousePos = mousePos;
        this.controller = controller;
        this.prepareBuffer = prepareBuffer;
    }

    @Override
    public void execute(PageViewport pageViewPort, Graphics2D g2d) {
        if (this.prepareBuffer) {
            pageViewPort.setForceFullRepaint(true);
            Graphics2D graphics2D = pageViewPort.paintObjectToBufferPrepareBuffer(g2d);
        }
        pageViewPort.paintObjectToBufferFlushBuffer(g2d);
        if (this.akfSource != null) {
            MyPage pageSource = this.akfSource.getPage();
            PageViewport viewPort = this.controller.getPageViewport();
            PointDouble pSource = viewPort.pageCmToPixel(new PointDouble(this.akfSource.getMidX(), this.akfSource.getMidY()), pageSource);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            g2d.setColor(Color.blue);
            g2d.setStroke(new BasicStroke(3.0f));
            if (this.akfDest != null) {
                MyPage pageDest = this.akfDest.getPage();
                PointDouble pDest = viewPort.pageCmToPixel(new PointDouble(this.akfDest.getMidX(), this.akfDest.getMidY()), pageDest);
                MyGraphics.drawArrow(pSource.x, pSource.y, pDest.x, pDest.y, 10.0, 10.0, g2d);
            } else {
                MyGraphics.drawArrow(pSource.x, pSource.y, this.mousePos.x, this.mousePos.y, 10.0, 0.0, g2d);
            }
        }
        pageViewPort.getController().paintTabOrderArrows(g2d);
    }

    public String toString() {
        return "PaintActiveTextfield";
    }
}

