/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import commands.MoveCommand;
import document.MarkedObjects;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.LeftUpCallBack;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import gui.components.popupmenus.rightmousemovepopup.ActionListenerAfterRightMouseMovePopup;
import gui.components.popupmenus.rightmousemovepopup.RightMouseMovePopup;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import util.math.PointDouble;
import util.math.RectangleDouble;

public class StateMoveObject
extends AbstractState
implements LeftUpCallBack,
ActionListenerAfterRightMouseMovePopup {
    private boolean moveBlocked = false;
    private Object semaphor = new Object();
    private ActionAfterMove actionAfterMove = ActionAfterMove.move;
    private PageViewPortController controller;
    private PointDouble mouseMoveBegin;
    private static StateMoveObject instance;
    private MouseEvent rightUpMouseEvent;
    private MouseDocumentInfo rightUpInfo;
    private boolean noMouseMoveBeforePopupDisabled = false;

    private StateMoveObject(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble mouseMoveBegin) {
        if (instance == null) {
            instance = new StateMoveObject(controller);
        }
        StateMoveObject.instance.controller = controller;
        instance.setMouseMoveBegin(mouseMoveBegin);
        return instance;
    }

    @Override
    public void ESCpressed() {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        stateInfo.getMarkedObjects().releasePreview();
        this.controller.getStateInfo().getHandlesOfMarkedObjects();
        this.controller.doRepaint();
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        this.actionAfterMove = ActionAfterMove.move;
        this.controller.addLeftUpCallBack(e, info, this);
        this.controller.doRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        Object object = this.semaphor;
        synchronized (object) {
            if (!this.moveBlocked && !this.noMouseMoveBeforePopupDisabled) {
                this.moveBlocked = true;
            }
            MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
            PointDouble newMid = this.calculateNewPosition(e, info, false);
            stateInfo.getMarkedObjects().getPreviewObject().moveTo(newMid);
            this.controller.addJobMouseMoveUpdate();
            this.controller.doRepaint();
        }
        object = this.semaphor;
        synchronized (object) {
            this.moveBlocked = false;
        }
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
        this.rightUpInfo = info;
        this.rightUpMouseEvent = e;
        this.noMouseMoveBeforePopupDisabled = true;
        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
        RightMouseMovePopup.getInstance(this).show(this.controller.getPageViewport(), info.getX(), info.getY());
    }

    public PointDouble getMouseMoveBegin() {
        return this.mouseMoveBegin;
    }

    public void setMouseMoveBegin(PointDouble mouseMoveBegin) {
        this.mouseMoveBegin = mouseMoveBegin;
    }

    private PointDouble calculateNewPosition(MouseEvent e, MouseDocumentInfo info, boolean calculatePositionOnDestinationPage) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        MarkedObjects markedObjects = stateInfo.getMarkedObjects();
        MyPage destinationPage = this.controller.pageUnderCursor(info.getPPanel());
        MyPage sourcePage = markedObjects.getPage();
        if (destinationPage == null) {
            destinationPage = sourcePage;
        }
        PointDouble mousePositionOnSourcePage = this.controller.pixelToPageCm(info.getPPanel(), sourcePage);
        PointDouble mousePositionOnDestPage = this.controller.pixelToPageCm(info.getPPanel(), destinationPage);
        PointDouble oldMid = new PointDouble(markedObjects.getMidX(), markedObjects.getMidY());
        PointDouble deltaToMid = this.mouseMoveBegin.getCopy();
        deltaToMid.sub(oldMid);
        PageController pc = this.controller.getPageController(destinationPage);
        PointDouble newMidSource = mousePositionOnSourcePage;
        newMidSource.sub(deltaToMid);
        PointDouble newMidDest = mousePositionOnDestPage;
        newMidDest.sub(deltaToMid);
        PointDouble deltaSourceDest = newMidSource.getCopy();
        deltaSourceDest.sub(newMidDest);
        double dx = newMidDest.x - oldMid.x;
        double dy = newMidDest.y - oldMid.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                newMidDest.y = oldMid.y;
            } else {
                newMidDest.x = oldMid.x;
            }
        }
        double width = markedObjects.getWidth();
        double height = markedObjects.getHeight();
        if (markedObjects.size() == 1) {
            MyObject object = markedObjects.get(0);
            RectangleDouble box = object.getBoundingBox();
            width = box.getWidth();
            height = box.getHeight();
        } else {
            width = markedObjects.getWidth();
            height = markedObjects.getHeight();
        }
        this.controller.setAllArtificialAndBorderLinesToInactive();
        PointDouble positionToSnap = newMidDest.getCopy();
        SnapInfo snapInfo = new SnapInfo();
        positionToSnap.y -= height / 2.0;
        positionToSnap.x -= width / 2.0;
        this.controller.snapToGridAndArtificialLines(positionToSnap, newMidDest, snapInfo);
        if (!snapInfo.xCoordinateGotSnapped) {
            positionToSnap.x = newMidDest.x + width / 2.0;
            this.controller.snapToGridAndArtificialLines(positionToSnap, newMidDest, snapInfo);
        }
        if (!snapInfo.xCoordinateGotSnapped) {
            positionToSnap.x = newMidDest.x;
            this.controller.snapToGridAndArtificialLines(positionToSnap, newMidDest, snapInfo);
        }
        if (!snapInfo.yCoordinateGotSnapped) {
            positionToSnap = newMidDest.getCopy();
            positionToSnap.y -= height / 2.0;
            this.controller.snapToGridAndArtificialLines(positionToSnap, newMidDest, snapInfo);
        }
        if (!snapInfo.yCoordinateGotSnapped) {
            positionToSnap.y = newMidDest.y + height / 2.0;
            this.controller.snapToGridAndArtificialLines(positionToSnap, newMidDest, snapInfo);
        }
        if (!snapInfo.yCoordinateGotSnapped) {
            positionToSnap.y = newMidDest.y;
            this.controller.snapToGridAndArtificialLines(positionToSnap, newMidDest, snapInfo);
        }
        SnapPositions snapPositions = pc.getSnapPositions();
        snapPositions.clearActivePositions();
        if (snapPositions.isEmpty()) {
            pc.renewSnapPositions(markedObjects);
        }
        double maxDistance = this.controller.getSnapDeltaCm();
        if (!snapInfo.xCoordinateGotSnapped) {
            positionToSnap = newMidDest.getCopy();
            positionToSnap.x -= width / 2.0;
            if (!snapPositions.snapPoint(positionToSnap, newMidDest, SnapPositions.Type.horizontal, maxDistance)) {
                positionToSnap.x = newMidDest.x + width / 2.0;
                if (!snapPositions.snapPoint(positionToSnap, newMidDest, SnapPositions.Type.horizontal, maxDistance)) {
                    positionToSnap.x = newMidDest.x;
                    snapPositions.snapPoint(positionToSnap, newMidDest, SnapPositions.Type.horizontalCenter, maxDistance);
                }
            }
        }
        if (!snapInfo.yCoordinateGotSnapped) {
            positionToSnap = newMidDest.getCopy();
            positionToSnap.y -= height / 2.0;
            if (!snapPositions.snapPoint(positionToSnap, newMidDest, SnapPositions.Type.vertical, maxDistance)) {
                positionToSnap.y = newMidDest.y + height / 2.0;
                if (!snapPositions.snapPoint(positionToSnap, newMidDest, SnapPositions.Type.vertical, maxDistance)) {
                    positionToSnap.y = newMidDest.y;
                    snapPositions.snapPoint(positionToSnap, newMidDest, SnapPositions.Type.verticalCenter, maxDistance);
                }
            }
        }
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                newMidDest.y = oldMid.y;
            } else {
                newMidDest.x = oldMid.x;
            }
        }
        newMidSource = deltaSourceDest;
        newMidSource.add(newMidDest);
        if (calculatePositionOnDestinationPage) {
            return newMidDest;
        }
        return newMidSource;
    }

    @Override
    public void leftUpCallBack(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        MyPage page = this.controller.pageUnderCursor(info.getPPanel());
        if (page == null || this.actionAfterMove == ActionAfterMove.cancel) {
            this.ESCpressed();
        } else {
            info.setPagePoint(this.controller.pixelToPageCm(info.getPPanel(), page));
            PointDouble newMid = this.calculateNewPosition(e, info, true);
            double dx = newMid.x - stateInfo.getMarkedObjects().getMidX();
            double dy = newMid.y - stateInfo.getMarkedObjects().getMidY();
            stateInfo.getMarkedObjects().copyToPreviewObject();
            stateInfo.getMarkedObjects().getPreviewObject().move(dx, dy);
            ArrayList<MyObject> objectsMarked = stateInfo.getMarkedObjects().getObjects();
            MyPage pageSource = stateInfo.getMarkedObjects().getPage();
            ArrayList<MyObject> objectsSource = pageSource.getObjects();
            ArrayList<MyObject> objectsToMove = new ArrayList<MyObject>();
            int i = 0;
            while (i < objectsSource.size()) {
                RectangleDouble rect;
                MyObject object = objectsSource.get(i);
                if (objectsMarked.contains(object) && (rect = object.getPreviewObject().getBoundingBox()).getRight() >= 0.0 && rect.getLeft() <= page.getWidthcm() && rect.getTop() <= page.getHeightcm() && rect.getBottom() >= 0.0) {
                    objectsToMove.add(object);
                }
                ++i;
            }
            stateInfo.getMarkedObjects().releasePreview();
            MoveCommand command = new MoveCommand(stateInfo, objectsToMove, dx, dy, page, this.actionAfterMove == ActionAfterMove.copy);
            this.controller.getStateInfo().getHandlesOfMarkedObjects();
            this.controller.doRepaint();
            this.controller.stateChanged(StateIdle.enter(this.controller));
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionAfterRightMouseMovePopupPerformed(ActionAfterMove actionAfterMove) {
        if (actionAfterMove != ActionAfterMove.cancel) {
            this.actionAfterMove = actionAfterMove;
            this.noMouseMoveBeforePopupDisabled = false;
            this.controller.addLeftUpCallBack(this.rightUpMouseEvent, this.rightUpInfo, this);
            this.controller.doRepaint();
        } else {
            this.ESCpressed();
        }
    }

    public static enum ActionAfterMove {
        move,
        copy,
        cancel,
        none;

    }
}

