/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.handles.MoveHandleController;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.StateMoveObject;
import gui.components.pageviewport.states.StatePullHandle;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StateRightDownOnHandle
extends AbstractState {
    private PageViewPortController controller;
    private static StateRightDownOnHandle instance;
    private PointDouble positionButtonPressed;
    private HandleController handle;

    private StateRightDownOnHandle(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble positionButtonPressed, HandleController handle) {
        if (instance == null) {
            instance = new StateRightDownOnHandle(controller);
        }
        controller.getCursorController().setEnabled(false);
        controller.getStateInfo().setKeyboardFocusableObject(null);
        StateRightDownOnHandle.instance.controller = controller;
        StateRightDownOnHandle.instance.positionButtonPressed = positionButtonPressed;
        StateRightDownOnHandle.instance.handle = handle;
        handle.renewSnapPositions(handle.getOriginalObject());
        return instance;
    }

    @Override
    public void ESCpressed() {
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        if (this.handle instanceof MoveHandleController) {
            stateInfo.getMarkedObjects().makePreview();
            this.controller.beginMouseMove();
            info.getController().stateChanged(StateMoveObject.enter(this.controller, info.getPPage()));
        } else {
            this.handle.startPulling(this.positionButtonPressed);
            this.controller.beginMouseMove();
            this.controller.stateChanged(StatePullHandle.enter(this.controller, this.positionButtonPressed, this.handle));
        }
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

