/*
 * Decompiled with CFR 0.152.
 */
package gui.components.popupmenus.contextmenu;

import document.text.MyTextField;
import document.text.Suggestions;
import gui.actions.editgroupzorder.CopyAction;
import gui.actions.editgroupzorder.CutAction;
import gui.actions.editgroupzorder.PasteAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TextContextmenuPopup
extends JPopupMenu
implements ActionListener {
    private MyTextField textfield;
    private Suggestions suggestions;
    private final int MAXSUGGESTIONS = 8;

    public TextContextmenuPopup(MyTextField textfield, Suggestions suggestions) {
        this.textfield = textfield;
        this.suggestions = suggestions;
        this.add(CopyAction.getInstance());
        this.add(CutAction.getInstance());
        this.add(PasteAction.getInstance());
        if (suggestions != null) {
            this.addSeparator();
            int i = 0;
            while (i < 8 && i < suggestions.getSuggestions().size()) {
                String s = suggestions.getSuggestions().get(i);
                JMenuItem item = new JMenuItem(s);
                item.setActionCommand(s);
                item.addActionListener(this);
                this.add(item);
                ++i;
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        this.textfield.insert(this.suggestions, s);
    }
}

