/*
 * Decompiled with CFR 0.152.
 */
package gui.components.tabbedpane;

import commands.RemoveQuickviewCommand;
import document.MyDocument;
import document.view.MyView;
import gui.actions.AddQuickviewAction;
import gui.actions.LoadImageAction;
import gui.actions.PrintAction;
import gui.actions.RemoveQuickviewAction;
import gui.actions.SaveAction;
import gui.actions.SaveAsAction;
import gui.actions.SaveAsPdfAction;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageScrollPaneController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.StateIdle;
import gui.components.tabbedpane.ButtonTabComponent;
import gui.components.tabbedpane.DocumentTabbedPane;
import gui.components.tabbedpane.ViewInfo;
import gui.components.zoomfactor.ZoomFactor;
import gui.components.zoomfactor.ZoomfactorComboBox;
import init.Settings;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.io.IO;
import util.language.Lang;
import util.language.LanguageComponent;
import util.logging.Log;

public class DocumentTabbedPaneController
implements LanguageComponent,
ChangeListener {
    private static DocumentTabbedPaneController instance;
    private DocumentTabbedPane tabbedPane;
    private ArrayList<ViewInfo> dBLInfos = new ArrayList();
    private ImageIcon documentIcon;
    private int lastSelectedIndex = 0;
    private boolean oldValueOfDocumentPresent = true;

    public static DocumentTabbedPaneController getInstance() {
        if (instance == null) {
            instance = new DocumentTabbedPaneController();
        }
        return instance;
    }

    public DocumentTabbedPaneController() {
        this.tabbedPane = new DocumentTabbedPane(this);
        this.tabbedPane.addChangeListener(this);
        Lang.registerComponent(this);
        try {
            this.documentIcon = new ImageIcon(IO.getDataFileURL("data/img/menu/16/document.png"));
        }
        catch (Exception e) {
            Log.log(3, "DocumentTabbedPaneController: Can't open icon.");
        }
        this.setActionsEnabled();
    }

    public void addView(MyView view) {
        ViewInfo dBLInfo = new ViewInfo(view);
        this.dBLInfos.add(dBLInfo);
        this.tabbedPane.addTab(view.getName(), this.documentIcon, dBLInfo.getPageScrollPaneController().getPageScrollPane(), dBLInfo.getDocumentTooltip());
        this.languageChanged();
        this.setActionsEnabled();
        this.stateChanged(new ChangeEvent(this.tabbedPane));
    }

    private void setActionsEnabled() {
        boolean documentPresent;
        boolean bl = documentPresent = this.dBLInfos.size() > 0;
        if (this.oldValueOfDocumentPresent != documentPresent) {
            boolean isEditModus;
            SaveAsAction.getInstance().setEnabled(documentPresent);
            SaveAction.getInstance().setEnabled(documentPresent);
            PrintAction.getInstance().setEnabled(documentPresent);
            LoadImageAction.getInstance().setEnabled(documentPresent);
            SaveAsPdfAction.getInstance().setEnabled(documentPresent);
            boolean bl2 = isEditModus = Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.edit;
            if (documentPresent) {
                MainPanelController.getInstance().getMainPanel().setupToolbars(true, isEditModus, isEditModus, true, isEditModus);
            } else {
                MainPanelController.getInstance().getMainPanel().setupToolbars(false, false, false, false, false);
            }
            this.oldValueOfDocumentPresent = documentPresent;
        }
    }

    public void insertView(MyView view, int index, int tabIndex) {
        ViewInfo dBLInfo = new ViewInfo(view);
        this.dBLInfos.add(index, dBLInfo);
        this.tabbedPane.insertTab(view.getName(), this.documentIcon, dBLInfo.getPageScrollPaneController().getPageScrollPane(), dBLInfo.getDocumentTooltip(), index);
        this.stateChanged(new ChangeEvent(this.tabbedPane));
        this.languageChanged();
        this.setActionsEnabled();
        this.stateChanged(new ChangeEvent(this.tabbedPane));
    }

    public void removeView(MyView view) {
        int i = this.getIndexOfView(view);
        if (i >= 0) {
            ViewInfo viewInfo = this.dBLInfos.get(i);
            this.dBLInfos.remove(i);
            int k = this.tabbedPane.indexOfComponent(viewInfo.getPageScrollPaneController().getPageScrollPane());
            this.tabbedPane.removeTabAt(k);
            this.stateChanged(new ChangeEvent(this.tabbedPane));
        }
    }

    public DocumentTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public MyView getView(int index) {
        if (index <= this.dBLInfos.size() - 1 && index >= 0) {
            return this.dBLInfos.get(index).getView();
        }
        Log.log(4, "DocumentTabbedPaneController.getDocument: Document with index " + index + " doesn't exist.");
        return null;
    }

    public int getIndexOfView(MyView view) {
        for (ViewInfo viewInfo : this.dBLInfos) {
            if (viewInfo.getView() != view) continue;
            return this.dBLInfos.indexOf(viewInfo);
        }
        return -1;
    }

    public int getTabIndexOfView(MyView view) {
        int index = this.getIndexOfView(view);
        if (index >= 0) {
            ViewInfo viewInfo = this.dBLInfos.get(index);
            return this.tabbedPane.indexOfComponent(viewInfo.getPageScrollPaneController().getPageScrollPane());
        }
        return -1;
    }

    public MyDocument getActiveDocument() {
        int index = this.tabbedPane.getSelectedIndex();
        return this.dBLInfos.get(index).getView().getDocument();
    }

    public MyView getActiveView() {
        int index = this.tabbedPane.getSelectedIndex();
        return this.dBLInfos.get(index).getView();
    }

    public PageScrollPaneController getActivePageScrollPaneController() {
        int index = this.tabbedPane.getSelectedIndex();
        return this.getPageScrollPaneController(index);
    }

    private PageScrollPaneController getPageScrollPaneController(int index) {
        if (index <= this.dBLInfos.size() - 1 && index >= 0) {
            return this.dBLInfos.get(index).getPageScrollPaneController();
        }
        Log.log(4, "DocumentTabbedPaneController.getPageScrollPaneController: Document with index " + index + " doesn't exist.");
        return null;
    }

    @Override
    public void languageChanged() {
        int i = 0;
        while (i <= this.tabbedPane.getTabCount() - 1) {
            this.tabbedPane.setToolTipTextAt(i, this.dBLInfos.get(i).getDocumentTooltip());
            ((ButtonTabComponent)this.tabbedPane.getTabComponentAt(i)).getButton().setToolTipText(Lang.get("Dieses Dokument schlie\u00dfen."));
            ++i;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PageScrollPaneController pspc = this.getPageScrollPaneController(this.lastSelectedIndex);
        if (pspc != null && pspc.getPageViewPortController().getState() != null) {
            pspc.getPageViewPortController().getState().ESCpressed();
        }
        this.lastSelectedIndex = this.tabbedPane.getSelectedIndex();
        pspc = this.getPageScrollPaneController(this.lastSelectedIndex);
        if (pspc != null) {
            PageViewPortController pvpc = pspc.getPageViewPortController();
            pvpc.getPageViewport().clearJobs();
            pvpc.stateChanged(StateIdle.enter(pvpc));
            if (pvpc.getView().isAutomaticZoomToFitPage()) {
                ZoomFactor zf = new ZoomFactor(1.0);
                zf.setWholePage(1.0);
                ZoomfactorComboBox.getInstance().setZoomFactor(zf);
                ZoomfactorComboBox.getInstance().setEnabled(false);
            } else {
                ZoomfactorComboBox.getInstance().setZoomFactor(pvpc.getPageViewport().getZoomFactor());
                ZoomfactorComboBox.getInstance().setEnabled(true);
            }
            pvpc.getPageViewport().grabFocus();
        }
        AddQuickviewAction.getInstance().setEnabledStatus();
        RemoveQuickviewAction.getInstance().setEnabledStatus();
    }

    public void closeTab(int index) {
        ViewInfo viewInfo = this.dBLInfos.get(index);
        if (viewInfo.getView().isDrawBorderAndShadow()) {
            if (viewInfo.getView().getDocument().isDirty()) {
                Object[] options = new Object[]{Lang.get("Speichern"), Lang.get("Verwerfen"), Lang.get("Abbrechen")};
                int n = JOptionPane.showOptionDialog(this.tabbedPane, Lang.get("Das aktuelle Dokument wurde seit der letzten \u00c4nderung noch nicht gespeichert."), Lang.get("Warnung"), 1, 2, null, options, options[2]);
                switch (n) {
                    case 0: {
                        SaveAction.getInstance().actionPerformed(null);
                        break;
                    }
                    case 1: {
                        this.closeAllTabsRelatedToTab(index);
                        break;
                    }
                }
            } else {
                this.closeAllTabsRelatedToTab(index);
            }
        } else {
            RemoveQuickviewCommand removeQuickviewCommand = new RemoveQuickviewCommand(viewInfo.getView().getDocument());
        }
        this.setActionsEnabled();
        this.stateChanged(new ChangeEvent(this.tabbedPane));
    }

    public ArrayList<MyDocument> getDirtyDocuments() {
        ArrayList<MyDocument> dirtyDocuments = new ArrayList<MyDocument>();
        for (ViewInfo viewInfo : this.dBLInfos) {
            MyDocument document = viewInfo.getView().getDocument();
            if (!document.isDirty() || dirtyDocuments.contains(document)) continue;
            dirtyDocuments.add(document);
        }
        return dirtyDocuments;
    }

    public void closeAllTabsWithoutAsking() {
        while (this.dBLInfos.size() > 0) {
            this.closeOneTab(0);
        }
    }

    private void closeOneTab(int index) {
        PageScrollPaneController pspc = this.getPageScrollPaneController(index);
        if (this.tabbedPane.getSelectedIndex() == index && pspc != null && pspc.getPageViewPortController() != null && pspc.getPageViewPortController().getState() != null) {
            pspc.getPageViewPortController().getState().ESCpressed();
        }
        this.dBLInfos.remove(index);
        this.tabbedPane.removeTabAt(index);
    }

    private void closeAllTabsRelatedToTab(int index) {
        ArrayList<Integer> closeList = this.getTabsToClose(index);
        for (Integer i : closeList) {
            this.closeOneTab(i);
        }
    }

    public ArrayList<Integer> getTabsToClose(int index) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        PageScrollPaneController pspc = this.getPageScrollPaneController(index);
        MyView view = pspc.getPageViewPortController().getView();
        MyDocument document = view.getDocument();
        int i = 0;
        while (i < this.dBLInfos.size()) {
            if (this.dBLInfos.get(i).getView().getDocument() == document) {
                list.add(0, new Integer(i));
            }
            ++i;
        }
        return list;
    }

    public void setVisibleTab(int tabIndex) {
        this.tabbedPane.setSelectedIndex(tabIndex);
    }
}

