/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.colorchooser;

import gui.components.toolbars.colorchooser.ColorChooserPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class ColorButton
extends JPanel
implements MouseListener {
    private static int borderWidth = 4;
    private static int buttonWidth = 18;
    private Color color;
    private ColorChooserPanel panel;
    private boolean isMouseOver = false;
    private boolean isMousePressed = false;

    public ColorButton(Color color, ColorChooserPanel panel) {
        this.setPreferredSize(new Dimension(buttonWidth, buttonWidth));
        this.setMaximumSize(new Dimension(buttonWidth, buttonWidth));
        this.color = color;
        this.panel = panel;
        this.addMouseListener(this);
        this.setFocusable(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isMouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isMouseOver = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isMousePressed = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isMousePressed = false;
        if (this.isMouseOver) {
            this.panel.colorButtonPressed(this.color);
            this.isMouseOver = false;
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isMouseOver || this.isMousePressed) {
            if (this.isMousePressed) {
                g.setColor(new Color(176, 176, 255));
            } else {
                g.setColor(Color.white);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 2);
        }
        g.setColor(this.color);
        g.fillRect(borderWidth, borderWidth, this.getWidth() - 2 * borderWidth, this.getHeight() - 2 * borderWidth - 1);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public static int getButtonWidth() {
        return buttonWidth;
    }
}

