/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.fontchooser;

import document.AbstractKeyboardFocusable;
import document.TextStyleChangeable;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.components.toolbars.fontchooser.FontCellRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import util.fontmanager.FontManager;

public class FontNameChooserComboBox
extends JComboBox
implements ActionListener {
    private static Object[] fontNames;
    private static FontNameChooserComboBox instance;
    private String fontName;
    private boolean noAction = false;

    public FontNameChooserComboBox() {
        fontNames = FontManager.getInstance().getUserFontNames();
        this.fontName = fontNames.length > 0 ? (String)fontNames[0] : "";
        this.setModel(new DefaultComboBoxModel<Object>(fontNames));
        this.setEditable(false);
        this.setRenderer(new FontCellRenderer());
        this.setMaximumRowCount(fontNames.length);
        this.addActionListener(this);
        this.setFocusable(false);
    }

    public static FontNameChooserComboBox getInstance() {
        if (instance == null) {
            instance = new FontNameChooserComboBox();
        }
        return instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.noAction) {
            this.fontName = (String)this.getSelectedItem();
            PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
            MarkedObjectsAndHandles info = controller.getStateInfo();
            AbstractKeyboardFocusable kf = info.getKeyboardFocusableObject();
            if (kf != null && kf instanceof TextStyleChangeable) {
                TextStyleChangeable tsc = (TextStyleChangeable)((Object)kf);
                tsc.setFontName(this.fontName);
                controller.updateCursor(true);
                controller.addJobPaintTextfield(kf, true);
                controller.doRepaint();
            }
        } else {
            this.noAction = false;
        }
    }

    public void setFontName(String name) {
        int index = -1;
        int i = 0;
        while (i < fontNames.length) {
            if (name.compareTo((String)fontNames[i]) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            this.noAction = true;
            this.setSelectedIndex(index);
            this.fontName = name;
        }
    }

    public String getFontName() {
        return this.fontName;
    }
}

