/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.fontchooser;

import document.AbstractKeyboardFocusable;
import document.TextStyleChangeable;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

public class FontSizeChooserComboBox
extends JComboBox {
    private static Object[] sizes = new Object[]{5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 18, 20, 24, 28, 30, 40, 50};
    private static FontSizeChooserComboBox instance;
    private int size = (Integer)sizes[0];
    private boolean noAction = false;

    public FontSizeChooserComboBox() {
        super(sizes);
        this.addActionListener(this);
        this.setFocusable(false);
    }

    public static FontSizeChooserComboBox getInstance() {
        if (instance == null) {
            instance = new FontSizeChooserComboBox();
        }
        return instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.noAction) {
            this.size = (Integer)this.getSelectedItem();
            PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
            MarkedObjectsAndHandles info = controller.getStateInfo();
            AbstractKeyboardFocusable kf = info.getKeyboardFocusableObject();
            if (kf != null && kf instanceof TextStyleChangeable) {
                TextStyleChangeable tsc = (TextStyleChangeable)((Object)kf);
                tsc.setFontSize(this.size);
                controller.updateCursor(true);
                controller.addJobPaintTextfield(kf, true);
                controller.doRepaint();
            }
        } else {
            this.noAction = false;
        }
    }

    public void setFontSize(int size) {
        int index = -1;
        int i = 0;
        while (i < sizes.length) {
            if (size == (Integer)sizes[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            this.noAction = true;
            this.setSelectedIndex(index);
            this.size = size;
        }
    }

    public int getFontSize() {
        return this.size;
    }
}

