/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.linedashedchooser;

import document.MyLineStyle;
import gui.components.toolbars.linedashedchooser.LinedashedChooserPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class LineDashedButton
extends JPanel
implements MouseListener {
    private static int borderWidth = 4;
    private static int buttonHeight = 20;
    private static int exampleWidth = 75;
    private int dashStyle;
    private LinedashedChooserPanel panel;
    private boolean isMouseOver = false;
    private boolean isMousePressed = false;
    private float[] individualDashStyle;
    private float lineWidth = 2.0f;

    public LineDashedButton(int dashStyle, LinedashedChooserPanel panel) {
        int width = 2 * borderWidth + exampleWidth;
        this.setPreferredSize(new Dimension(width, buttonHeight));
        this.setMaximumSize(new Dimension(width, buttonHeight));
        this.dashStyle = dashStyle;
        this.makeIndividualDashStyle();
        this.panel = panel;
        this.addMouseListener(this);
        this.setFocusable(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isMouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isMouseOver = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isMousePressed = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isMousePressed = false;
        if (this.isMouseOver) {
            this.panel.dashStyleButtonPressed(this.dashStyle);
            this.isMouseOver = false;
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isMouseOver || this.isMousePressed) {
            if (this.isMousePressed) {
                g.setColor(new Color(176, 176, 255));
            } else {
                g.setColor(Color.white);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 2);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        if (this.dashStyle == 0) {
            g2d.setStroke(new BasicStroke(this.lineWidth));
        } else {
            g2d.setStroke(new BasicStroke(this.lineWidth, 0, 0, 1.0f, this.individualDashStyle, 0.0f));
        }
        g2d.drawLine(borderWidth, buttonHeight / 2, borderWidth + exampleWidth, buttonHeight / 2);
    }

    public void setDashStyle(int dashStyle) {
        this.dashStyle = dashStyle;
        this.makeIndividualDashStyle();
        this.repaint();
    }

    private void makeIndividualDashStyle() {
        this.individualDashStyle = (float[])(this.dashStyle == 0 ? null : MyLineStyle.makeIndividualDashStyle(this.dashStyle, this.lineWidth));
    }
}

