/*
 * Decompiled with CFR 0.152.
 */
package util.fontmanager;

import java.awt.Font;
import java.util.ArrayList;

public class MachineIndependentFont {
    private Font font;
    private int style = 0;
    private boolean isDerivedFont = false;
    private ArrayList<MachineIndependentFont> derivedFonts = new ArrayList();

    public MachineIndependentFont(Font font) {
        this.font = font;
        this.style = 0;
        if (font.getName().contains("italic") || font.getName().contains("Italic")) {
            this.style += 2;
        }
        if (font.getName().contains("bold") || font.getName().contains("Bold")) {
            ++this.style;
        }
    }

    public Font derive(int style, float size) {
        if (this.style == style) {
            return this.font.deriveFont(0, size);
        }
        Font df = this.searchDerivedFont(style, size);
        if (df != null) {
            return df;
        }
        return this.font.deriveFont(style, size);
    }

    private Font searchDerivedFont(int style, float size) {
        Font derivedFont = null;
        for (MachineIndependentFont mf : this.derivedFonts) {
            if (mf.style != style) continue;
            derivedFont = mf.getFont().deriveFont(style, size);
            break;
        }
        return derivedFont;
    }

    public Font getFont() {
        return this.font;
    }

    public int getStyle() {
        return this.style;
    }

    public void addDerivedFont(MachineIndependentFont df) {
        this.derivedFonts.add(df);
    }

    public boolean isDerivedFont() {
        return this.isDerivedFont;
    }

    public void setDerivedFont(boolean isDerivedFont) {
        this.isDerivedFont = isDerivedFont;
    }
}

