/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import document.Serializable;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.io.Base64;
import util.io.ByteBufferInputStream;
import util.logging.Log;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class ImageStorer
implements Serializable {
    public boolean isDestructiveCompressionType;
    private byte[] buffer = null;
    private BufferedImage bufferedImage;
    private String filetype = "";
    private String resourceName = "";

    public void readFromFile(File file) throws IOException {
        this.filetype = this.getFileType(file.getName());
        this.isDestructiveCompressionType = this.isDestructive(this.filetype);
        if (this.isDestructiveCompressionType) {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            int bytes = (int)file.length();
            this.buffer = new byte[bytes];
            bis.read(this.buffer);
            bis.close();
            this.bufferedImage = ImageIO.read(new ByteBufferInputStream(this.buffer));
        } else {
            this.bufferedImage = ImageIO.read(file);
        }
    }

    private boolean isDestructive(String filetype) {
        boolean b = filetype.compareTo("jpg") == 0 ? true : true;
        return b;
    }

    public String getFileType(String filename) {
        if (filename.length() >= 3) {
            return filename.substring(filename.length() - 3).toLowerCase();
        }
        return "";
    }

    public boolean isDestructiveCompressionType() {
        return this.isDestructiveCompressionType;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public String getFiletype() {
        return this.filetype;
    }

    @Override
    public void deSerialize(Element element) {
        Boolean b = XMLReader.elementBooleanAttribute(element, "isdestructivecompression");
        if (b != null) {
            this.isDestructiveCompressionType = b;
        }
        NodeList nodeList = element.getChildNodes();
        String data = nodeList.item(0).getNodeValue();
        this.buffer = Base64.decode(data);
        try {
            this.bufferedImage = ImageIO.read(new ByteBufferInputStream(this.buffer));
        }
        catch (IOException ex) {
            Log.log(4, "ImageStorer.deSerialize: can't read image");
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(ImageStorer.getXMLName(), parentElement);
        XMLWriter.addAttribute(element, "resourcename", this.getResourceName());
        XMLWriter.addAttributeBoolean(element, "isdestructivecompression", this.isDestructiveCompressionType);
        String data = Base64.encodeBytes(this.buffer);
        XMLWriter.addCDATA((Node)element, data);
        return null;
    }

    public static String getXMLName() {
        return "imagedata";
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
}

