/*
 * Decompiled with CFR 0.152.
 */
package util.svg;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import util.math.PointFloat;

public class SVGPathParser {
    private String d;
    private int pos;

    public GeneralPath createGeneralPath(String d) throws IllegalArgumentException {
        this.d = d;
        this.pos = 0;
        GeneralPath ret = new GeneralPath();
        String token = this.getNextToken();
        while (token != null) {
            PointFloat p3;
            PointFloat p2;
            Point2D currentPoint = ret.getCurrentPoint();
            if (token.equals("M")) {
                PointFloat p = this.readPoint();
                ret.moveTo(p.x, p.y);
            } else if (token.equals("m")) {
                PointFloat p = this.readPoint();
                ret.moveTo(currentPoint.getX() + (double)p.x, currentPoint.getY() + (double)p.y);
            } else if (token.equals("Z") || token.equals("z")) {
                ret.closePath();
            } else if (token.equals("L")) {
                PointFloat p = this.readPoint();
                ret.lineTo(p.x, p.y);
            } else if (token.equals("l")) {
                PointFloat p = this.readPoint();
                ret.lineTo(currentPoint.getX() + (double)p.x, currentPoint.getY() + (double)p.y);
            } else if (token.equals("H")) {
                float x = this.parseNumericToken(this.getNextToken());
                ret.lineTo((double)x, ret.getCurrentPoint().getY());
            } else if (token.equals("h")) {
                float x = this.parseNumericToken(this.getNextToken());
                ret.lineTo((double)x, currentPoint.getY() + ret.getCurrentPoint().getY());
            } else if (token.equals("V")) {
                float y = this.parseNumericToken(this.getNextToken());
                ret.lineTo(ret.getCurrentPoint().getX(), (double)y);
            } else if (token.equals("v")) {
                float y = this.parseNumericToken(this.getNextToken());
                ret.lineTo(currentPoint.getX() + ret.getCurrentPoint().getX(), (double)y);
            } else if (token.equals("C")) {
                PointFloat p1 = this.readPoint();
                p2 = this.readPoint();
                p3 = this.readPoint();
                ret.curveTo(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y);
            } else if (token.equals("c")) {
                PointFloat p1 = this.readPoint();
                p2 = this.readPoint();
                p3 = this.readPoint();
                ret.curveTo(currentPoint.getX() + (double)p1.x, currentPoint.getY() + (double)p1.y, currentPoint.getX() + (double)p2.x, currentPoint.getY() + (double)p2.y, currentPoint.getX() + (double)p3.x, currentPoint.getY() + (double)p3.y);
            } else if (token.equals("Q")) {
                PointFloat p1 = this.readPoint();
                p2 = this.readPoint();
                ret.quadTo(p1.x, p1.y, p2.x, p2.y);
            } else if (token.equals("q")) {
                PointFloat p1 = this.readPoint();
                p2 = this.readPoint();
                ret.quadTo(currentPoint.getX() + (double)p1.x, currentPoint.getY() + (double)p1.y, currentPoint.getX() + (double)p2.x, currentPoint.getY() + (double)p2.y);
            } else {
                if (token.equals("T") || token.equals("t") || token.equals("S") || token.equals("s") || token.equals("A") || token.equals("a")) {
                    throw new IllegalArgumentException("Command \"" + token + "\" not implemented yet.");
                }
                throw new IllegalArgumentException("Unknown command: \"" + token + "\"");
            }
            token = this.getNextToken();
        }
        return ret;
    }

    private String getNextToken() {
        while (this.pos < this.d.length() && this.isWhitespace(this.d.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos >= this.d.length()) {
            return null;
        }
        char c0 = this.d.charAt(this.pos);
        boolean c0Numeric = this.isNumeric(c0);
        int posEnd = this.pos;
        int i = this.pos + 1;
        while (i < this.d.length()) {
            char ci = this.d.charAt(i);
            boolean ciNumeric = this.isNumeric(ci);
            if (c0Numeric != ciNumeric || this.isWhitespace(ci)) break;
            ++posEnd;
            ++i;
        }
        String ret = this.d.substring(this.pos, posEnd + 1);
        this.pos = posEnd + 1;
        return ret;
    }

    private boolean isNumeric(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '.' || c == '-' || c == '+';
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == ',' || c == '\n' || c == '\r';
    }

    private float parseNumericToken(String token) throws NumberFormatException {
        return Float.parseFloat(token);
    }

    private PointFloat readPoint() throws NumberFormatException {
        String x = this.getNextToken();
        String y = this.getNextToken();
        return new PointFloat(this.parseNumericToken(x), this.parseNumericToken(y));
    }
}

